; Copyright 2007-2022 by Anatoliy ivashkov.

;#pragma usePoFile 0
Include "UIA.jsh"
Include "HjGlobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
include "thebat.JSM"
include "thebat.JSH"
include "MSAAConst.jsh"
import "virtual.jsd" ; expose function declarations for the Virtual Cursor
import "default.jsd"
use "thebat_Header.jsb"
;use "tracerforSkype.jsb"

Void Function AutoStartEvent ()
	if GlobalAppSettings  != wc_TMailerForm then
		delay(2)
		LoadAppSettings ()
	endif
	SendMessage (GetAppMainWindow (GetCurrentWindow ()), 274, 61488, 0)
	
	
	let giReadText = false
	;let gbNotSayLine = true
	let GlobalSegmentDate = false
	let GlobalSegmentTime = false
	let GlobalPrevDate = cscNull
	let GlobalPrevTime = cscNull
	let GlobalSegmentDate = 1
	let GlobalSegmentTime = 1
	;AutoStartEvent ()
EndFunction

Void Function AutoFinishEvent ()
	let globalMessageList = Null ()
	let gbOffCopyFromBuffer = false
	let gbNotRepeatRow = false
	let gbMessageList = false
	let gbNotSayLine = false
	let giReadText = false
	let giCurLeft = false ;      .
	let giCurRight = false ;     .
	let giCurTop = false ;    
	let giCurBottom = false ;     
	let giCurColumn= false ;     
	let giFlagsAddr = false
EndFunction

Void Function LoadAppSettings ()
	HandlingTheScheme ("TheBatAppLoad")
	var handle hWnd = GetFocus ()
let GlobalAppSettings = GetWindowClass (GetAppMainWindow (hWnd))
	let TheBatConfigurationFileName = GetActiveConfiguration () + jcfFileType
	let GlobalSayMessageHeaders = IniReadInteger (PathOptionsSectionName, flg_MessageHeaders , 0, TheBatConfigurationFileName)
	let GlobalMessageSayall= iniReadInteger (PathOptionsSectionName, Flg_MessageSayall, 0, TheBatConfigurationFileName)
	let GlobalMessageSayAllKeys = IniReadInteger (PathOptionsSectionName, flg_MessageSayAllKeys, 0, TheBatConfigurationFileName)
	let gi_HeaderReadListOrFolder = IniReadInteger (MessageAndFolderOptionsSectionName	, FolderList, 0, TheBatConfigurationFileName)
	let giColumCaunt = GetColumnsNumberInFoldersOrList (hWnd)
EndFunction

Void Function SayObjectTypeAndText (optional int nLevel)
	var
	int iLeft, int iRight, int iTop, int iBottom,
	int iTemp,
	int iRole, int iChild,
	object obj,
	string sRealClass,
	string sClass,
	int iObjectType,
	string sTextRec,
	string sObjName,
	handle hRealWnd,
	handle hWnd
	
	
	;sayinteger(19)
	let hwnd = GetFocus ()
	let hRealWnd = GetRealWindow (hWnd)
	let sClass = GetWindowClass (hwnd)
	let sRealClass = GetWindowClass (hRealWnd)
	
	if IsFolderList (hwnd) then
		return
	endif
	MSAARefresh (true, 10)
	
	if sClass == wc_TMemo && sRealClass != wc_TAddressEditor then
		Say (GetControlName (), OT_CONTROL_NAME)
		SayLineUnit (0)
		IndicateControlType (WT_MULTILINE_EDIT, cscspace, cscspace)
		return
	endif
	
	;saystring(sClass)
	let obj = GetCurrentObject (iChild)
	let sObjName=GetObjectName(TRUE)
	let iObjectType = GetObjectSubTypeCode (true)
	
	if (GetObjectTypeCode (true) == wt_ListBox)
		&& (GetWindowTypeCode (hwnd) != wt_ListBox)
		&& sObjName != "Item #0/331"
		&& sRealClass != wc_TSmartBat
		then
		goToTheFirstElement (obj, iChild, iRole)
		if not obj.AccName(1) then
			IndicateControlType (WT_LISTBOX, cscspace, cscspace)
		endif
		return
	endif
	
	if iObjectType == WT_LISTBOXITEM
		;|| (sClass == wc_TSpTBXCheckBox)
		|| (sClass == wc_TSpTBXRadioButton)
		then
		if (iObjectType == WT_LISTBOXITEM)
			&& (GetWindowTypeCode (hwnd) == WT_LISTBOX ) then
			let sObjName = obj.AccName(iChild)
			IndicateControlType (WT_LISTBOX, cscspace, cscspace)
			if sObjName then
				Say (sObjName, ot_line)
			endif
			return
		endif
		if (iObjectType == WT_LISTBOXITEM)
			&& (GetWindowTypeCode (hwnd) == WT_LISTVIEW)
			then
			let sObjName = obj.AccName(iChild)
			IndicateControlType (WT_LISTVIEW, cscspace, cscspace)
			if !sObjName then
				Say (GetSelectedText (false, true), ot_line)
			endif
			SayObjectActiveItem (true)
			return
		endif
		if obj then
			/*
			if sClass  == wc_TSpTBXCheckBox
			then
			GetWindowRect (hwnd, ileft, iright, itop, ibottom)
			say (GetTextBetween (ileft, iright, 4), ot_line)
			return
			endif
			;IndicateControlType (WT_LISTBOX, cscspace, cscspace)
			*/
			if !obj.accname(ichild) then
				say(obj.AccValue(iChild), ot_line)
			else
				GetObjectText (obj, iChild, sTextRec)
				Say (sTextRec, ot_line)
				Say (PositionInGroup (), OT_POSITION)
			endif
			return
		else
			if nLevel == 0 && sClass == cwc_DirectUIHWND then
				Sayline ()
				return
			endif
			if nLevel >= 0 ;&& sRealClass == cWc_dlg32770 then
				return
			endif
			SayObjectActiveItem (false)
			let obj = GetObjectAtPoint (iChild, GetCursorCol (), GetCursorRow ())
			if obj then
				let obj = obj.accparent
				GetObjectText (obj, iChild, sTextRec)
				Say (sTextRec, ot_line)
				return
			endif
		endif
		return
	endif
	
	;    .
	if (sClass  == wc_TComboBox
		|| sClass == wc_TEdit
		||sClass == wc_TBatMemo
		||sClass == wc_TBatStaticText
		||sClass == wc_TFilterConditionText
		|| sClass == wc_TMemo
		|| sClass == wc_TSpinEdit)
		&& sRealClass != wc_TFolderSelector
		;wc_TActionEditor
		then
		if sClass == wc_TSpinEdit && GetWindowClass (GetParent (hWnd)) != wc_TTabSheet then
			let iObjectType = GetWindowSubtypeCode (hWnd, true)
			let sTextRec = GetWindowName (GetParent (hWnd))
		else
			let sTextRec = GetWindowName (hWnd)
		endif
		;  .
		if GetWindowHierarchyY (hWnd) == 5 && GetWindowHierarchyX (GetLastWindow (hWnd)) == 13 then
			if GetWindowHierarchyX (hWnd) == 13 then
				let sTextRec = ""
			elif GetWindowHierarchyX (hWnd) == 12 then
				let sTextRec = ""
			elif GetWindowHierarchyX (hWnd) == 7 then
				let sTextRec = ":"
			elif GetWindowHierarchyX (hWnd) == 4 then
				let sTextRec = "()"
			endif
		endif
		
		;  .
		if GetWindowHierarchyY (hWnd) == 6 && GetWindowHierarchyX (GetLastWindow (GetParent (hWnd))) == 5 then
			;  .
			if GetWindowHierarchyX (GetParent (hWnd)) == 1 then
				if GetWindowHierarchyX (hWnd) == 4 then
					let sTextRec = FormatString("%1 %2", " ", "  (Mr, Ms):")
				elif GetWindowHierarchyX (hWnd) == 3 then
					let sTextRec = "  (III, Jr.):"
				endif
				;  
			elif GetWindowHierarchyX (GetParent (hWnd)) == 2 then
				if GetWindowHierarchyX (hWnd) == 3 then
					let sTextRec = FormatString("%1 %2", " ", "")
				elif GetWindowHierarchyX (hWnd) == 1 then
					let sTextRec = ":"
				endif
				;   .
			elif GetWindowHierarchyX (GetParent (hWnd)) == 5 then
				if GetWindowHierarchyX (hWnd) == 5 then
					let sTextRec = FormatString("%1 %2", " ", ", :")
				elif GetWindowHierarchyX (hWnd) == 2 then
					let sTextRec = "ZIP /  :"
				endif
			endif
		endif
		
		;   .
		if GetWindowHierarchyY (hWnd) == 6 && GetWindowHierarchyX (GetLastWindow (GetParent (hWnd))) == 4 then
			var string sParentWinName = GetWindowName (GetParent (hWnd))
			;   .
			if GetWindowHierarchyX (GetParent (hWnd)) == 3 then
				if GetWindowHierarchyX (hWnd) == 7 then
					let sTextRec = FormatString("%1 %2", sParentWinName, sTextRec)
				elif GetWindowHierarchyX (hWnd) == 6 then
					let sTextRec = ""
				elif GetWindowHierarchyX (hWnd) == 4 then
					let sTextRec = ""
				elif GetWindowHierarchyX (hWnd) == 2 then
					let sTextRec = ""
				endif
			endif
			
			if GetWindowHierarchyX (GetParent (hWnd)) == 4 then
				if GetWindowHierarchyX (hWnd) == 5 then
					let sTextRec = FormatString("%1 %2", sParentWinName, sTextRec)
				endif
			endif
		endif
		
		if ((not sTextRec && sClass != wc_tEdit) ||sClass == wc_TBatMemo) then
			GetWindowRect (hwnd, ileft, iright, itop, ibottom)
			let sTextRec = GetTextInRect (iLeft, iTop -(iBottom -iTop), iRight, iTop, 0, ignorecolor, ignorecolor, 0, 0)
		endif
		if (sRealClass == wc_TGlobalPrefDlg && sClass != wc_TSpinEdit ) && sTextRec then
			let sTextRec = cscNull
		endif
		IndicateControlType(iObjectType,cscSpace,cscSpace)
		let sTextRec = FormatString("%1 %2", sTextRec, obj.accValue(iChild))
		say (sTextRec, ot_Jaws_message)
		return
	endif
	
	if (sRealClass == wc_TGlobalPrefDlg
		|| sRealClass == wc_TMsgEditor
		|| sRealClass == wc_TMsgRedirector)
		&& sClass  == wc_TXTRichEdit && nLevel ==0
		then
		;SayLine ()
		return
	elif sClass  == wc_TXTRichEdit && nLevel > 0 then
		return
	elif sRealClass == wc_TMailerForm
		&& sClass  == wc_TXTRichEdit && nLevel ==0 then
		SetTheFocusToView (hWnd)
		return
	endif
	
	if iObjectType == WT_STATIC
		|| GetWindowTypeCode (hwnd, false) == WT_COMBOBOX
		then
		let sObjName = obj.accname(ichild)
		if !sObjName then
			let sObjName = obj.accValue(ichild)
		endif
		GetObjectText (obj, iChild, sTextRec)
		let sObjName = FormatString("%1 %2", sObjName, sTextRec)
		IndicateControlType(WT_COMBOBOX,cscSpace,cscSpace)
		say (sObjName, ot_line)
		return
	endif
	
	if GetWindowClass (GetRealWindow (hwnd)) == wc_TFmMessageDelay &&
		sClass ==wc_TDateTimePicker then
		var string sChar, string sPrevDateTime
		let obj = GetCurrentObject (iChild)
		let sObjName = obj.accName(iChild)
		
		if StringContainsChars (sObjName, cscPeriod) then
			let sChar = cscPeriod
			let sPrevDateTime = GlobalPrevDate
		elif StringContainsChars (sObjName, cScColon) then
			let sChar = cScColon
			let sPrevDateTime = GlobalPrevTime
		endif
		
		if not StringContains (sObjName, sPrevDateTime) then
			let iTemp = StringSegmentCount (sObjName, sChar)
			while (iTemp > 1) && (StringSegment (sObjName, sChar, iTemp) == StringSegment (sPrevDateTime, sChar, iTemp))
				let iTemp = iTemp -1
			endWhile
		endif
		
		if sChar == cscPeriod then
			let iTemp = GlobalSegmentDate
			let sPrevDateTime = sObjName
		elif  sChar == cScColon then
			let iTemp = GlobalSegmentTime
			let sPrevDateTime = sObjName
		endif
		say (StringSegment (sPrevDateTime, sChar, iTemp), ot_line)
		return
	endif
	
	if sClass == wc_TListView && obj.accrole(ichild) == 33
		|| IsFolderList (hwnd)
		then
		if obj.accrole(ichild) == 33 && GetCurrentScriptKeyName () == "Shift+Control+2" then
			;sayinteger(2)
			let obj = GetObjectFromEvent (hWnd, objid_client, 1, iChild)
			obj.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iChild)
		endif
		return
	endif
	
	if (sClass != cwcChromeBrowserClass ) then
		SayObjectTypeAndText (nLevel)
	endif
EndFunction

Script Tab ()
	var
	int winLeft, int wintop, int winright, int winbottom,
	int ichild, int iclient, int lt, int tt, int wt, int ht, int rt, int bt,
	object oclient,
	handle hWnd,
	string sClass,
	string sRealClass,
	handle hNxtWnd
	
	;SaveCursor ()
	let giFlagsAddr = false
	let globalMessageList = Null ()
	if FindWindow (FindTopLevelWindow (wc_TfCustomizeScEdForm, cscNull), wc_TXShortcutEditor, cscNull)
		== GetFocus () then
		let hNxtWnd = GetNextWindow (GetFocus ())
		While (GetWindowClass (GetNextWindow (hNxtWnd)) == wc_TSpTBXButton)
			if IsKeyWaiting () then
				return
			endif
			let hNxtWnd = GetNextWindow (hNxtWnd )
		EndWhile
		SetFocus (hNxtWnd )
		return
	endif
	
	let hWnd = GetFocus ()
	let sClass = GetWindowClass (hWnd)
	if FindTopLevelWindow (wc_TXTHeaderDropdownList, cscnull) == hWnd
		then
		let hWnd = FindTopLevelWindow (wc_TXTHeaderDropdownList, cscnull)
		GetWindowRect (hWnd, winLeft, winright, wintop, winbottom)
		let oclient = GetObjectFromEvent (hwnd, objid_client, ichild, iclient)
		let oclient = GetCurrentObject (iclient)
		oClient.accLocation(Intref(lT), Intref(tT), Intref(wT), Intref(hT), iClient)
		let lT = lT +1
		let rT = lT + wT
		let tt = tt +1
		let lT = (rT -winleft) >>1
		let bt = (tt -wintop ) +ht>>1
		postMessage(hwnd,wm_lbuttonDown, 0, MakeLong (lt, bt))
		postMessage(hwnd,wm_lbuttonUp, 0, MakeLong (lt, bt))
		TabKey ()
		JAWSHome ()
		let gbSetClass = true
		return
	endif
	
	if (sClass == cwcChromeBrowserClass) then
		let hWnd = FindWindow (GetRealWindow (hWnd), wc_TFoldersFrame , cscNull)
		let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
		SetFocus(hWnd)
		return
	endif
	
	if (sClass == wc_TMicroEdW) && GetWindowHierarchyY (hWnd) ==9 then
		let hWnd = GetFirstWindow (GetParent (hWnd))
		SetFocus(hWnd)
		return
	endif
	PerformScript Tab()
	
	pause()
	delay(1)
	let hWnd = GetFocus()
	let sClass = GetWindowClass (hWnd)
	let hNxtWnd = GetRealWindow (hWnd)
	let sRealClass = GetWindowClass (hNxtWnd)
	;saystring(sclass)
	if sClass == wc_TChromiumMessageFrame then
		let hWnd = FindWindow (hWnd, cwcChromeBrowserClass, cscNull)
		SetFocus(hWnd)
		let sClass = GetWindowClass (hWnd)
	endif
	
	if (sRealClass == wc_TMsgEditor
		|| sRealClass == wc_TMsgRedirector)
		&& (sClass == wc_TXTRichEdit)
		then
		SayLine ()
		return
	endif
	
	;RestoreCursor ()
EndScript

Script ShiftTab ()
	var
	int winLeft, int wintop, int winright, int winbottom,
	int ichild, int iclient, int lt, int tt, int wt, int ht, int rt, int bt,
	object oclient,
	handle hWnd,
	string sClass,
	string sRealClass,
	handle hRealWnd
	
	;SaveCursor ()
	let giFlagsAddr = false
	let globalMessageList = Null ()
	
	if FindWindow (FindTopLevelWindow (wc_TfCustomizeScEdForm, cscNull), wc_TXShortcutEditor, cscNull)
		== GetFocus ()  then
		SetFocus (FindWindow (FindTopLevelWindow (wc_TfCustomizeScEdForm, cscNull), wc_TListBox, cscNull))
		return
	endif
	
	let hWnd = GetFocus ()
	let sClass = GetWindowClass (hWnd)
	let hRealWnd = GetRealWindow (hWnd)
	let sRealClass = GetWindowClass (hRealWnd)
	
	if sRealClass == wc_TSmartBat
		&& sClass == wc_TMicroEdW then
		let hWnd = FindWindow (hRealWnd, wc_TContainerPanel, cscNull)
		if IsWindowVisible (hWnd) then
			let hWnd = FindWindow (hWnd, wc_TPageControl, cscNull)
		else
			let hWnd = FindWindow (hRealWnd, wc_TPageControl, cscNull)
		endif
		SetFocus (hWnd)
		return
	endif
	
	if (sClass == cwcChromeBrowserClass ) then
		if sRealClass == wc_TMsgRedirector then
			let hWnd = FindWindow (hRealWnd, wc_TXTRichEdit, cscNull)
		elif !IsWindowObscured (hWnd) then
			if GetCursorCol () >=1 && GetCursorRow () > 1 then
				JAWSTopOfFile ()
			endif
			let hWnd = FindWindow (hRealWnd, wc_TMessageListFrame, cscNull)
			delay (1)
			let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
		endif
		SetFocus (hWnd)
		return
	endif
	
	if FindTopLevelWindow (wc_TXTHeaderDropdownList, cscnull) == hWnd then
		let hWnd = FindTopLevelWindow (wc_TXTHeaderDropdownList, cscnull)
		GetWindowRect (hWnd, winLeft, winright, wintop, winbottom)
		let oclient = GetObjectFromEvent (hwnd, objid_client, ichild, iclient)
		let oclient = GetCurrentObject (iclient)
		oClient.accLocation(Intref(lT), Intref(tT), Intref(wT), Intref(hT), iClient)
		let lT = lT +1
		let rT = lT + wT
		let tt = tt +1
		let lT = (rT -winleft) >>1
		let bt = (tt -wintop ) +ht>>1
		postMessage(hwnd,wm_lbuttonDown, 0, MakeLong (lt, bt))
		postMessage(hwnd,wm_lbuttonUp, 0, MakeLong (lt, bt))
		ShiftTabKey ()
		JAWSEnd ()
		let gbSetClass = true
		return
	endif
	
	if (sClass == wc_TMicroEdW) && GetWindowHierarchyY (hWnd) ==9 then
		let hWnd = DefinitionNumberOfClasses (hWnd)
		SetFocus(hWnd)
		return
	endif
	
	PerformScript ShiftTab()
	
	delay(1, 1)
	let hWnd = GetFocus ()
	let sClass = GetWindowClass (hWnd)
	let hRealWnd = GetRealWindow (hWnd)
	let sRealClass = GetWindowClass (hRealWnd)
	;saystring(sclass)
	;saystring(GetWindowClass (globalprevfocus))
	if (sRealClass == wc_TMsgEditor
		|| sRealClass == wc_TMsgRedirector)
		&& (sClass == wc_TXTRichEdit)
		then
		SayLine ()
		return
	endif
	
	if (sClass == cwcChromeBrowserClass) ;|| sClass == wc_TMicroEdW)
		&& GlobalWinClass then
		let hWnd = FindWindow (GetRealWindow (hWnd), wc_TMessageListFrame, cscNull)
		delay(1)
		let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
		setfocus(hWnd)
	endif
	;RestoreCursor ()
EndScript

Script NextDocumentWindow ()
	var
	string sClass,
	string sRealClass,
	handle hRealWnd,
	handle hNextWindow
	
	let hNextWindow = GetCurrentWindow ()
	let sClass =GetWindowClass (hNextWindow)
	let hRealWnd = GetRealWindow (hNextWindow)
	let sRealClass = GetWindowClass (hRealWnd)
	
	if sClass == wc_TViewerCss
		|| sClass == wc_TMicroEdW
		then
		if (IsWindowVisible (FindWindow (FindWindow (hRealWnd, wc_TMsgViewFrame, cscNull), wc_TListView, cscNull))) then
			let hNextWindow = FindWindow (hRealWnd, wc_TListView, cscNull)
		elif sRealClass == wc_TGlobalPrefDlg then
			let hNextWindow = FindWindow (hRealWnd, wc_TComboBox, cscNull)
		elif sRealClass == wc_tAddressEditor then
			let hNextWindow = FindWindow (hRealWnd, wc_TComboBox, cscNull)
		elif sRealClass == wc_TFolderEditor
			|| sRealClass == wc_TUserDialog
			|| sRealClass == wc_TQRDisplayForm
			then
			let hNextWindow = FindWindow (hRealWnd, wc_TComboBox, cscNull)
			if !IsWindowVisible (hNextWindow) then
				let hNextWindow = FindWindow (hRealWnd, wc_TButton, cscNull)
				if sRealClass == wc_TQRDisplayForm then
					let hNextWindow = GetLastWindow (hNextWindow)
				endif
			endif
		elif sRealClass == wc_TQTemplatesEditor
			then
			let hNextWindow = FindWindow (hRealWnd, wc_TEdit, cscNull)
		endif
		let globalWinClass = CSCNull
		SetFocus (hNextWindow)
		return
	endif
	
	PerformScript NextDocumentWindow()
EndScript

Script PreviousDocumentWindow ()
	var
	string sClass,
	string sRealClass,
	handle hRealWnd,
	handle hPrevWindow
	
	let hPrevWindow = GetCurrentWindow ()
	let sClass =GetWindowClass (hPrevWindow)
	let hRealWnd = GetRealWindow (hPrevWindow)
	let sRealClass = GetWindowClass (hRealWnd)
	
	if sClass == wc_TViewerCss
		||sClass == wc_TMicroEdW then
		if sRealClass == wc_TGlobalPrefDlg then
			let hPrevWindow = FindWindow (hRealWnd, wc_TTreeView, cscNull)
		elif sRealClass == wc_TAddressEditor then
			let hPrevWindow = FindWindow (hRealWnd, wc_TCheckBox, cscNull)
		elif sRealClass == wc_TFolderEditor
			|| sRealClass == wc_TUserDialog
			|| sRealClass == wc_TQRDisplayForm
			then
			let hPrevWindow = FindWindow (hRealWnd, wc_TPageControl, cscNull)
		elif sRealClass == wc_TQTemplatesEditor
			then
			let hPrevWindow = FindWindow (hRealWnd, wc_THotKey, cscNull)
		endif
		let globalWinClass = CSCNull
		SetFocus (hPrevWindow)
		return
	endif
	PerformScript PreviousDocumentWindow ()
EndScript

HANDLE Function DefinitionNumberOfClasses (handle hWnd)
	var object oFocUIA = CreateObjectEx ("freedomsci.UIA", false, "UIAScriptAPI.x.manifest"),
	object oFoc = oFocUIA.GetElementFromHandle(GetAppMainWindow (hWnd)),
	object oConditionClass = oFocUIA.CreateStringPropertyCondition (UIA_ClassNamePropertyId, wc_TMicroEdW),
	object oColecTion = oFoc.FindAll(TreeScope_Descendants|TreeScope_Children, oConditionClass),
	int iCount = oColecTion.Count, int i
	if iCount >= 1 then
		let i = iCount -1
		let hwnd = oColection(i).nativeWindowHandle
		if GetWindowHierarchyY (hWnd) == 9 then
			let hWnd = FindWindow (GetRealWindow (hWnd), wc_TMessageListFrame, cscNull)
			delay(1)
			let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
		endif
	else
		let hwnd = Null()
	endif
	Return hWnd
EndFunction

Void Function SetTheFocusToView (handle hWindows)
	var
	handle hRealwindow
	let hRealwindow = GetRealWindow (hWindows)
	if GetCurrentScriptKeyName () == cksTab
		|| GetCurrentScriptKeyName () == cksAltControlRightArrow
		||GetCurrentScriptKeyName () == cksAltControlLeftArrow
		then
		var handle hWnd = DefinitionNumberOfClasses (hWindows)
		let hWindows = FindWindow (hRealwindow, wc_TMsgViewFrame, cscNull)
		if hWindows && IsWindowVisible (hWnd) then
			let hWindows = hWnd
		elif hWindows && IsWindowVisible (FindWindow (hWindows, cwcChromeBrowserClass , cscNull)) then
			let hWindows = FindWindow (hWindows, cwcChromeBrowserClass , cscNull)
		elif IsWindowObscured (FindWindow (hWindows, cwcChromeBrowserClass , cscNull))then
			let hWindows = FindWindow (hRealwindow, wc_TMsgViewFrame, cscNull)
			let hWindows = FindWindow (hWindows, wc_TChromiumMessageFrame, cscNull)
			let hWindows = FindWindow (GetNextWindow (GetParent (hWindows)), cwcChromeBrowserClass , cscNull)
			SetFocus (hWindows)
		elif hWindows && IsWindowVisible (FindWindow (hWindows, wc_TViewerCss, cscNull)) then
			let hWindows = FindWindow (hWindows, wc_TViewerCss, cscNull)
		endif
		SetFocus (hWindows)
	else
		if GetCurrentScriptKeyName () == cksShiftTab
			then
			let hWindows = FindWindow (hRealwindow, wc_TMessageListFrame, cscNull )
			if hWindows then
				let hWindows = FindWindow (hWindows, wc_TXTreeView, cscNull )
			endif
			if IsWindowVisible (hWindows) then
				SetFocus (hWindows)
			else
				let hWindows = FindWindow (hRealwindow, wc_TMsgViewFrame, cscNull)
				if hWindows&& IsWindowVisible (FindWindow (hWindows, wc_TMicroEdW, cscNull)) then
					let hWindows = FindWindow (hWindows, wc_TMicroEdW, cscNull)
				elif hWindows  && IsWindowVisible (FindWindow (hWindows, cwcChromeBrowserClass , cscNull)) then
					let hWindows = FindWindow (hWindows, cwcChromeBrowserClass , cscNull)
				elif hWindows && IsWindowVisible (FindWindow (hWindows, wc_TViewerCss, cscNull)) then
					let hWindows = FindWindow (hWindows, wc_TViewerCss, cscNull)
				endif
				SetFocus (hWindows)
			endif
		else
			let hWindows = FindWindow (hRealwindow, wc_TMsgViewFrame, cscNull)
			if hWindows&& IsWindowVisible (FindWindow (hWindows, wc_TMicroEdW, cscNull)) then
				let hWindows = FindWindow (hWindows, wc_TMicroEdW, cscNull)
			elif hWindows  && IsWindowVisible (FindWindow (hWindows, cwcChromeBrowserClass , cscNull)) then
				let hWindows = FindWindow (hWindows, cwcChromeBrowserClass , cscNull)
			elif hWindows && IsWindowVisible (FindWindow (hWindows, wc_TViewerCss, cscNull)) then
				let hWindows = FindWindow (hWindows, wc_TViewerCss, cscNull)
			endif
			SetFocus (hWindows)
		endif
	endif
EndFunction

int function HandleCustomWindows (handle hwnd)
	if (GetWindowName (GetAppMainWindow (hwnd)) == " " && GetWindowClass (hwnd) == wc_TButton)
		&& (StringContains (gsKeyName , "Alt+F4") || StringContains (gsKeyName , "Alt+X") || (gsKeyName == "Enter" &&GetWindowClass (hwnd) != cwc_Button))
		then
		let GlobalAppSettings  = cscNull
		HandlingTheScheme ("TheBatAppUnload")
		return true
	endif
	var
	int TheTypeCode, int iRole, int iChild, int iTemp, int iObjType,
	object obj,
	string sTextRec, string WinClass, string sRealClass,
	handle hRealwindow, handle hWindows
	
	if globalprevClass && (GetCurrentScriptKeyName () == "enter" || gsKeyName  == cksEscape || gsKeyName  == cksSpace || StringContains (gsKeyName, "Alt+F4")) then
		if GetCurrentScriptKeyName () == "enter" then
			ScheduleFunction ("SetCustomizeListView", 1)
		endif
		let gi_HeaderReadListOrFolder = False
		let globalprevClass = cscNull
	endif
	;sayinteger(7)
	let hWindows = GetFocus ()
	let WinClass =GetWindowClass (hwnd)
	let hRealwindow = GetRealWindow (hWnd)
	let sRealClass = GetWindowClass (hRealwindow)
	let globalWinClass = CSCNull
	;saystring(WinClass)
	
	let TheTypeCode =GetWindowSubTypeCode(GetFocus ())
	if !TheTypeCode then
		let TheTypeCode =GetObjectSubTypeCode(true)
	endif
	
	if WinClass == wc_TMsgViewFrame || WinClass == wc_TXTRichEdit then
		if hWnd && IsWindowVisible (FindWindow (hRealwindow, cwcChromeBrowserClass , cscNull)) then
			let hWnd = FindWindow (hRealwindow, cwcChromeBrowserClass , cscNull)
			SetFocus (hWnd)
		endif
	endif
	
	if !IsFolderList (hwnd)
		&& !IsMessageList (hwnd)
		&& !GlobalMenuMode
		then ;   .
		;  .
		if (WinClass == wc_TViewerCss)
			|| (winClass == wc_TMicroEdW)
			|| (winClass == cwcChromeBrowserClass && !GlobalMessageSayall)
			then
			let globalwinclass = winClass
			if GlobalMessageSayAllKeys && GlobalMessageSayall != 2
				&& sRealClass != wc_TMsgEditor
				then
				PerformScript SayAll()
				return
			endif
			if !globalMessageList then
				if ((sRealClass == wc_TMailerForm) || (sRealClass == wc_TMsgListViewer)) && (GetCurrentScriptKeyName () == cksTab) && !GlobalMessageSayall then
					if (winClass == cwcChromeBrowserClass ) then
						SpeechOff ()
						RefreshWindow (GetCurrentWindow ())
						JAWSTopOfFile ()
						pause()
						delay(0, 1)
						SpeechOn ()
					endif
					if GetWindowHierarchyY (hWnd) == 9 then
						SayLine()
					else
						PerformScript SayAll()
					endif
				elif (sRealClass == wc_TMsgListViewer) && (GetCurrentScriptKeyName () == cksEnter) && GlobalMessageSayall == 2 then
					let giReadText = true
					let globalMessageList = GlobalPrevFocus
					ScheduleFunction (sf_ReadText, 1)
				else
					if (winClass != cwcChromeBrowserClass ) then
						SayLine ()
					endif
				endif
			endif
			return true
		elif (winClass == cwcChromeBrowserClass ) then
			if GlobalMessageSayall ==2 && GetCurrentScriptKeyName () != cksTab then
				delay(3)
				SayAll()
				return true
			endif
			let globalwinclass = winClass
			SayLine ()
			return true
		endif ;   .
		
		if (WinClass  == wc_TRichViewEdit
			|| WinClass  == wc_TRichEdit
			|| WinClass  == wc_TRichView)
			&& (GetWindowClass (GetParent (GetParent (hwnd))) == wc_TFrQreply
			|| sRealClass == wc_TMsgEditor
			|| sRealClass == wc_TFolderMaintenancer
			|| sRealClass == wc_TFolderEditor)
			then
			SayLine ()
			return true
		endif
		
		if (sRealClass == wc_TMsgEditor
			|| sRealClass == wc_TMsgRedirector)
			&& (WinClass == wc_TXTRichEdit)
			then
			let gbNotSayLine = false
			return true
		endif
		
		if WinClass == wc_TAddressBookGrid  then
			if giCurColumn < 2 then
				let giCurTop = GetLineTop ()
				let giCurBottom = GetLineBottom ()
				HomeEndMovement (UnitMove_First)
			elif !giFlagsAddr && giCurColumn>= 2 then
				let obj = GetCurrentObject (iChild)
				if !obj.AccName(iChild) then
					SpeechOff ()
					HomeEndMovement (UnitMove_First)
					let giCurColumn = 2
					let giCurTop = GetLineTop ()
					let giCurBottom = GetLineBottom ()
					ReadTheDestinationCell (hwnd, giCurTop, giCurBottom, giCurColumn)
					SpeechOn ()
					return true
				endif
				ReadTheDestinationCell (hwnd, GetLineTop (), GetLineBottom (), giCurColumn)
				let giFlagsAddr = true
				return true
			endif
			return true
		endif
		
		if sRealClass == wc_TfrmCustomizer2
			&& (TheTypeCode == WT_LISTBOXITEM
			|| WinClass == wc_TXTreeView)
			then
			SayObjectActiveItem (true)
			return true
		endif
		
		if sRealClass == wc_TFolderEditor
			&& WinClass == wc_TContainerPanel
			|| WinClass == wc_TRadioGroup
			|| WinClass == wc_TGroupBox
			then
			let hWnd = FindWindow (hRealwindow, wc_TTreeView, cscNull)
			SetFocus (hWnd)
			return true
		endif
		
		;   SayObjectTypeAndText
		If TheTypeCode== WT_EDIT ||
			TheTypeCode== WT_ReadOnlyEdit ||
			TheTypeCode== WT_MULTILINE_EDIT ||
			thetypeCode == wt_ListView ||
			thetypeCode == wt_ListBox ||
			TheTypeCode == wt_button
			then
			if ((WinClass == wc_TEdit ||WinClass == wc_TBatMemo) ||
				sRealClass == wc_TAddressEditor) ||
				(winClass == cwc_Button || (WinClass == wc_TButton && !gbCleanOutFolder)) ||
				((sRealClass == wc_TWMEDictionaryEditor ||
				sRealClass == wc_TQTSelector ||
				sRealClass == wc_TBackupCentre ||
				sRealClass == wc_TFolderSelector ||
				sRealClass == wc_TSmartBat ||
				sRealClass == wc_TViewModeSetup ||
				sRealClass == wc_TSelectAccs ||
				sRealClass == wc_TGlbBackup)
				&& (WinClass == wc_TListView ||
				WinClass == wc_TXTreeView ||
				WinClass == wc_TXTVCheckListBox))
				then
				if ((thetypeCode == wt_ListView
					|| thetypeCode == wt_ListBox)
					&& sRealClass != wc_TSmartBat)
					then
					if goToTheFirstElement (obj, iChild, iRole) then
						return false
					endif
				endif
				if (winClass == cwc_Button || (WinClass == wc_TButton && !gbCleanOutFolder)) then
					SayButton (hWnd)
				endif
			endif
		endif
		
		if sRealClass == wc_TInstallSelectAccounts
			&& winClass == wc_TXTVCheckListBox then
			return true
		endif
		
		MSAARefresh (true, 10)
		if WinClass == wc_Chrome_WidgetWin_0 then
			return false
		endif
		
		if WinClass == wc_TListView && iRole == 33 && GetCurrentScriptKeyName () == "Shift+Control+2" then
			let obj = GetObjectFromEvent (hWnd, objid_client, 1, iChild)
			obj.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iChild)
		endif
		SayObjectTypeAndText ()
		return true
	endif;   if  isWindowMessage
	
	if IsFolderList (hwnd) then
		if gbCleanOutFolder then
			HandlingTheScheme ("TheBatMessageClearFolder")
			let gbCleanOutFolder = false
		endif
		let gi_HeaderReadListOrFolder = IniReadInteger (MessageAndFolderOptionsSectionName	, FolderList, 0, TheBatConfigurationFileName)
		;sayinteger(gi_HeaderReadListOrFolder)
		let giColumCaunt = GetColumnsNumberInFoldersOrList (hWnd)
		;sayinteger(giColumCaunt)
		IndicateControlType(WT_TREEVIEW,cscSpace, cscSpace)
	elif IsMessageList (hwnd) then
		let 	GlobalNotReadMessage = IniReadInteger (MessageAndFolderOptionsSectionName	, flg_NotReadOrReadMessage, 0, TheBatConfigurationFileName)&0x01
		let GlobalReadMessage = IniReadInteger (MessageAndFolderOptionsSectionName	, flg_NotReadOrReadMessage, 0, TheBatConfigurationFileName)&0x02
		let iObjtype = GetObjectSubTypeCode (true)
		let giColumCaunt = GetColumnsNumberInFoldersOrList (hWnd)
		var int iValue = IniReadInteger (MessageAndFolderOptionsSectionName	, MessageList, 0, TheBatConfigurationFileName)
		if giColumCaunt&0x01 && iValue then
			let gi_HeaderReadListOrFolder = giColumCaunt
		else
			let gi_HeaderReadListOrFolder = iValue
		endif
		UIARefresh ()
		goToTheFirstElement (obj, iChild, iRole)
		if iRole == ROLE_SYSTEM_LIST && iObjtype == wt_ListBox
			&& Not Obj.AccName(1)
			then
			IndicateControlType(wt_listview,cscNull,cscNull)
			return true
		endif
		if !iChild then
			return true
		endif
		GetObjectText (obj, iChild, sTextRec)
		if not sTextRec
			&& obj.AccName(iChild) then
			let iTemp = obj.AccChildCount
			SpeechOff ()
			if iTemp == iChild then
				PriorLine ()
				NextLine ()
			else
				NextLine ()
				PriorLine ()
			endif
			SpeechOn ()
		endif
		IndicateControlType(wt_listview,cscSpace,cscSpace)
		UIARefresh (true, 3)
		return false
	endif
	
	if sRealClass == wc_TFolderSelector
		|| sRealClass == wc_TActionEditor
		|| sRealClass == wc_TMessageFinder
		||sRealClass == wc_TExtSetup
		||sRealClass == wc_TImapNewFolderManager
		&& WinClass== wc_TXTreeView
		then
		SayObjectTypeAndText ()
		return true
	endif
	return false
EndFunction

Void Function SetCustomizeListView ()
	PerformScriptByName ("CustomizeListView")
EndFunction

Void Function ReadTheDestinationCell (handle hWnd, optional int iTop, optional int iBottom, optional int nColumn)
	var
	object obj, object oHScroll, object oNameSpace,
	int Left, int Top, int Right, int Bottom, int Width, int Height,
	int iTemp, int iHScroll, int iChild, int iChildCount,
	string sListOfHeadings, string sTextRec,
	handle hHeaderWindow
	
	let hHeaderWindow = FindWindow (GetRealWindow (hWnd), wc_THeaderControl, cscNull)
	delay(1, 1)
	let obj = GetObjectFromEvent (hHeaderWindow, OBJID_client, nColumn, iTemp)
	let iChildCount = obj.AccChildCount
	obj.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
	obj.acclocation(intref(left), intref(top), intref(width), intref(height), itemp)
	let Left = Left + 1
	let Right = Left + Width
	let giCurLeft = Left
	let giCurRight = Right
	
	let oNameSpace = GetCurrentObject (iChild)
	if !(oNameSpace.accname(ichild)) then
		saylineunit(1)
	else
		let sListOfHeadings = obj.accname(iTemp)
		let sTextRec = GetTextInRect (Left, iTop, Right, iBottom, 0, ignorecolor, ignorecolor, 0, 0)
		if sTextRec then
			say (sListOfHeadings, OT_HELP_BALLOON)
			Say (sTextRec, ot_line)
		elif sListOfHeadings == "" then
			say (sListOfHeadings, OT_line)
			FindGraphickColorsMarkup (hWnd, Left, iTop, Right, iBottom)
		else
			;if !FindGraphickColorsMarkup (hWnd, Left, iTop, Right, iBottom) then
			say (sListOfHeadings, OT_line)
			say(cscSpace, ot_line)
			;endif
		endif
	endif
	return
EndFunction

Int Function goToTheFirstElement (object ByRef Obj, int ByRef iChild, int ByRef iRole)
	let obj = GetFocusObject (iChild)
	let iRole = obj.accrole(iChild)
	;sayinteger(iRole)
	if iRole == ROLE_SYSTEM_LIST then
		obj.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, 1)
		return true
	elif iRole == ROLE_SYSTEM_LISTITEM then
		obj.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iChild)
		delay(1)
		obj.accname(iChild)
		return true
	endif
	return false
EndFunction

Int Function HandlingTheScheme (string KeyName)
	var string SMFType = ".smf", string sPath, int NumSegment
	let SMFType = FormatString("%1%2", GetActiveConfiguration (), SMFType)
	let sPath = IniReadString ("Other Behavior Table", KeyName, "", SMFType)
	let NumSegment = StringToInt (StringSegment (sPath, "|", 1))
	let sPath = StringSegment(sPath, "|", NumSegment  +1)
	if NumSegment == 2 then
		if StringContains (sPath, "ProgramData\\Freedom Scientific\\JAWS") then
			let sPath = StringSegment (sPath, cScDoubleBackSlash, -1)
			PlaySound (FindJAWSSoundFile (sPath))
		else
			PlaySound (sPath)
		endif
		delay(4)
	elif NumSegment == 1 then
		let sPath = StringSegment (sPath, ":", 2)
		say (sPath, ot_line)
	endif
	return NumSegment
EndFunction

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
	;sayinteger(5)
	FocusChangedEvent (FocusWindow, PrevWindow)
EndFunction

Void Function SayFocusedWindow  ()
	var
	int iChild, int iTemp, int iObjtypeParent, int iObjtype,
	string keystroke, string sObjText, string sMessageNumber,
	object obj,
	Handle hWnd
	
	;sayinteger(15)
	let hwnd = GetFocus ()
	let iObjtypeParent = GetObjectSubTypeCode (true, 1)
	let iObjtype= GetObjectSubTypeCode (true)
	let obj = GetCurrentObject (iChild)
	let sObjText = obj.accName (iChild)
	
	if ((iObjtypeParent == WT_ListBOX) && (iObjtype == WT_LISTBOXITEM))
		|| ((GetWindowClass (GetRealWindow (hWnd)) == wc_TFolderSelector)
		&&(GetWindowClass (GetAppMainWindow (hWnd)) == wc_TMsgListViewer))
		then
		if gi_HeaderReadListOrFolder then
			if !StringContains (sObjText, cscComa) then
				let sMessageNumber = StringSegment (sObjText, cscTab, 1)
				let sMessageNumber = FormatString ("%1 %2 %3", sMessageNumber, StringSegment (StringSegment (sObjText, cscTab, 3), cscspace, 1), StringSegment (StringSegment (sObjText, cscTab, 4), cscspace, 1))
			else
				let sMessageNumber =  StringSegment (sObjText, cscComa, 1)
				var string sSegmentSpace1 = StringSegment (StringSegment (sMessageNumber, cscTab, 3), cscspace, 1),
				string sSegmentSpace2 = StringSegment (StringSegment (sMessageNumber, cscTab, 4), cscspace, 1)
				let sMessageNumber = FormatString ("%1   %2   %3   %4", StringSegment (sMessageNumber, cscTab, 1), StringSegment (sMessageNumber, cscTab, 2), sSegmentSpace1, sSegmentSpace2)
			endif
			Say (sMessageNumber, ot_line)
		else
			;sayinteger(gi_HeaderReadListOrFolder)
			Say(sObjText,ot_line)
		endif
		return
	endif
	
	if IsMessageList (hwnd) then
		let keystroke = GetCurrentScriptKeyName ()
		if (keystroke == cksShiftDelete  ||
			keystroke == cksDelete)
			&& gbFlagOfKeystroke then
			StopSpeech ()
			HandlingTheScheme ("TheBatDeleteMessage")
			let gbFlagOfKeystroke = false
		endif
		;sayinteger(gi_HeaderReadListOrFolder)
		if gi_HeaderReadListOrFolder then
			If ((GetCharacterAttributes () & ATTRIB_BOLD)
				|| (GetCharacterAttributes () & ATTRIB_ITALIC)
				|| (GetCharacterAttributes () & ATTRIB_UNDERLINE)
				|| (GetCharacterAttributes () & ATTRIB_STRIKEOUT))
				&& iObjtype != WT_LISTBOX then
				if GlobalNotReadMessage then
					Say (msg_UnreadMessage_S, ot_Line)
				endif
			elif GlobalReadMessage then
				Say (msg_readMessage_S, ot_Line)
			EndIf
		endif
		if !gi_HeaderReadListOrFolder then
			Say(sObjText,ot_line)
		else
			SayTextItem (hWnd, obj, iChild)
			var object o, int iCount, string sAttach, string sHTML, int iWindowAttach
			let hWnd = FindWindow (GetRealWindow (hWnd), wc_TListView, cscnull)
			let iWindowAttach = IsWindowVisible (hWnd)
			if iWindowAttach then
				let o = GetObjectFromEvent (hWnd, objid_client, 0, iCount)
				let iCount = o.AccChildCount
				let sAttach = o.AccName(iCount)
				let sHTML = o.AccName(1)
				if StringContains (sHTML, "html") && !StringContains (sAttach, "html") then
					HandlingTheScheme ("TheBatAtachAndHTMLMessage")
				elif StringContains (sHTML, "html") then
					HandlingTheScheme ("TheBatHTMLMessage")
				elif !StringContains (sAttach, "html") then
					HandlingTheScheme ("TheBatMessageAttach")
				endif
			endif
		endif
		Say (PositionInGroup (), OT_POSITION)
		return
	endif
	
	if GetWindowClass (hWnd) == wc_TXTRichEdit then
		say (GetWindowName (GetRealWindow (hWnd)), ot_window_name)
		sayline()
		return
	elif GetWindowClass (hWnd) == wc_tEdit then
		say (GetWindowName (GetRealWindow (hWnd)), ot_window_name)
		SayWindowTypeAndText (hwnd)
		return
	endif
	SayFocusedWindow ()
EndFunction

string Function SayTextItem (handle hWnd, object oItem, int nChild,optional  int bHeader)
	var
	int l, int t, int w, int h, int r, int b,
	int tText, int bText, int lText, int rText, int wText, int hText,
	int iColumn, int iPage, int iTemp, int iScroll,
	string sValue, string sText, string sHeader,
	object oPage, object oMaxCols, object oHeader,
	int value
	
	let opage = GetObjectFromEvent (hwnd, objid_hscroll, 2, ipage)
	While (oPage.accstate(iPage) != STATE_SYSTEM_INVISIBLE)
		opage.AccDoDefaultAction(ipage)
		if IsKeyWaiting () then
			return
		endif
	EndWhile
	
	var int lh, int th, int rh, int bh, int wh, int hh
	oItem.accLocation(Intref(lText), Intref(tText), Intref(wText), Intref(hText), nChild)
	let lText = lText +1
	let tText = tText +1
	let bText = tText + hText
	
	let iColumn  = -1
	if bHeader then
		let iScroll = giColumCaunt > ~iColumn
	else
		if giColumCaunt > 1 then
			let iScroll = giColumCaunt && gi_HeaderReadListOrFolder>>~iColumn
		else
			let iScroll = giColumCaunt
		endif
	endif
	;sayinteger(gi_HeaderReadListOrFolder>>~iColumn)
	;	sayinteger(giColumCaunt|gi_HeaderReadListOrFolder>>~iColumn)
	while iScroll
		let oMaxCols = GetObjectFromEvent (hwnd, objid_client, iColumn, iTemp)
		oMaxCols.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), iTemp)
		let l = l+1
		let r = l + w
		let t = t +1
		let b = t +h
		if IsKeyWaiting () then
			return
		endif
		let sHeader= GetTextInRect (l, t, r, b, 0, IgnoreColor, IgnoreColor, 0, 0)
		let sText = GetTextInRect (l, tText, r, bText, 0, ignorecolor, ignorecolor, 0, 0)
		let opage = GetObjectFromEvent (hWnd, objid_hscroll, 4, ipage)
		let lText = lText +w
		While (oPage.accstate(iPage) != STATE_SYSTEM_INVISIBLE) && wText < lText
			opage.AccDoDefaultAction(ipage)
			let oMaxCols = GetObjectFromEvent (hWnd, objid_client, iColumn, iTemp)
			oMaxCols.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), iTemp)
			let l = l+1
			let r = l + w
			let t = t +1
			let b = t +h
			if IsKeyWaiting () then
				return
			endif
			if GetTextInRect (l, tText, r, bText, 0, ignorecolor, ignorecolor, 0, 0) then
				let sText = FormatString("%1%2", sText, GetTextInRect (l, tText, r, bText, 0, ignorecolor, ignorecolor, 0, 0))
			endif
		endwhile
		let sHeader = stringChopLeft (sHeader, 1)
		if bHeader then
			let sValue = FormatString("%1%2", sValue, sHeader+cscListSeparator)
			let iScroll = giColumCaunt > ~iColumn
			let iColumn = iColumn -1
		else
			if giColumCaunt > 1 then
				if (gi_HeaderReadListOrFolder>>~iColumn)&1 then
					say(sHeader, OT_TOASTS)
				else
					let sText = cscNull
				endif
			endif
			say(sText, ot_line)
			let iColumn = iColumn -1
			let iScroll = giColumCaunt && gi_HeaderReadListOrFolder>>~iColumn
			;		sayinteger(giColumCaunt | gi_HeaderReadListOrFolder>>~iColumn)
		endif
	endwhile
	let opage = GetObjectFromEvent (hwnd, objid_hscroll, 2, ipage)
	While (oPage.accstate(iPage) != STATE_SYSTEM_INVISIBLE)
		opage.AccDoDefaultAction(ipage)
		if IsKeyWaiting () then
			return
		endif
	EndWhile
	
	if bHeader then
		let bHeader = false
		return sValue
	endif
EndFunction

void function ObjStateChangedEvent(handle hObj, int iObjType, int nChangedState, int nState, int nOldState)
	;SayInteger (11)
	var
	int x,
	int y
	let x=GetWindowLeft (hObj)
	let y=GetCursorRow ()
	
	if hObj != GetFocus() then
		return
	EndIf
	if nSelectingText then
		return
	EndIf
	if HJDialogObjStateChangeSpoken(hObj,iObjType,nChangedState,nState,nOldState) then
		return
	EndIf
	;Announce the list item when it changes state:
	if iObjType == wt_ListBoxItem
		|| iObjType == wt_ExtendedSelect_ListBox
		|| iObjType == wt_MultiSelect_ListBox then
		if (!nState || nChangedState == CTRL_SELECTED)
			&& !InHJDialog() then
			;When the item becomes selected, we only announce the name, not the state.
			;When the item becomes deselected, "Not Selected" is part of the name, so we don't need to explicitly announce it.
			;SayObjectTypeAndText ()
			;		Say(GetCurrentListViewItemName(),ot_line)
			return
		EndIf
	EndIf
	;For the rest of the object types, do not announce change to unavailable state:
	if nState == CTRL_GRAYED then
		return
	EndIf
	if iObjType == wt_RadioButton then
		;if the radio buttons are items in a treeview,
		;then speak them as we would speak a treeview item:
		if GetObjectSubtypeCode(GetFocus()) == wt_TreeView then
			SayTreeViewItem()
			return
		EndIf
		;FocusChangedEvent should announce when radio buttons gain focus,
		;and they should need no further announcement:
		; The only exception is radio buttons in Java applications.  They do not
		; become checked when they gain focus.  Instead you must actually press
		; the space bar in order for a Java radio button to become checked.
		if ( FALSE == IsJavaWindow (hObj) )
			then
			return
		endIf
	EndIf
	if iObjType == WT_TREEVIEW
		|| iObjType == WT_TREEVIEWITEM then
		SayTreeViewLevel(false)
	ElIf iObjType == wt_button
		|| iObjType == wt_StartButton
		|| iObjType == wt_Checkbox then
		;for buttons, we do not want announcement of the pressed state.
		if !(nState & ctrl_pressed) then
			if nState & CTRL_Indeterminate then
				;announce only partially checked, not the checked which is also set
				IndicateControlState(iObjType,CTRL_Indeterminate)
			else
				IndicateControlState(iObjType,(nState & ~ctrl_selected))
			EndIf
		EndIf
	else
		IndicateControlState(iObjType, nChangedState)
	endIf
EndFunction

Void Function ValueChangedEvent (handle hwnd, int objId, int childId, int nObjType, string sObjName, string sObjValue,optional int bIsFocusObject)
	;sayinteger(12)
	var
	string WinClass
	let WinClass = GetWindowClass (hwnd)
	if IsJavaWindow (hwnd) then
		if (WT_UNKNOWN == nObjType)
			|| (WT_LEFTRIGHTSLIDER == nObjType)
			|| (WT_PROGRESSBAR == nObjType)
			|| (WT_SLIDER == nObjType)
			|| (WT_STATIC == nObjType)
			|| (WT_UPDOWNSLIDER == nObjType) then
			Say(sObjValue,ot_line)
		elif (
			( WT_EDIT_SPINBOX == nObjType )
			|| ( WT_SPINBOX == nObjType )
			)
			then
			;Do Nothing.  Otherwise the value will be spoken twice, once by SayLineUnit and
			;once in response to the Value Changed Event.
		else
			Say(GetObjectValue(),ot_line)
		endIf
	endif
	if nObjType == WT_Edit
		&& getObjectSubtypeCode() == WT_EditCombo then
		; This seems to happen at random;
		; nObjType should normally be WT_EditCombo also.  [DGL, 2007-10-03]
		let nObjType = WT_EditCombo
	endIf
	if SilenceNonFocusedSeekBarsForMagic(hWnd, nObjType) then
		Return
	endIf
	if bIsFocusObject
		|| (GlobalMenuMode == Menu_Active && IsRibbonControl(hWnd))
		|| (WinClass == wc_TComboBox && GetWindowClass (GetRealWindow (hWnd)) != wc_TGlobalPrefDlg) then
		;sayinteger(WT_COMBOBOX )
		if (nObjType == WT_COMBOBOX && (GetNextWindow (hWnd) || GetWindowClass (GetRealWindow (hWnd)) == wc_TUserSelectDlg) || GetWindowClass (GetRealWindow (hWnd)) == wc_TActionEditor) ||
			nObjType == WT_EditCOMBO
			|| (nObjType==WT_SLIDER && FocusWindowSupportsUIA()) then
			;sayinteger(nObjType)
			Say(sObjValue,ot_line)
		EndIf
	EndIf
	if GetWindowClass (GetRealWindow (hWnd)) == cWc_dlg32770
		&& winclass == cwc_Edit
		then
		delay(4)
	endif
EndFunction

void Function WindowActivatedEvent(handle hWnd)
	var
	string winclass
	;SayInteger (13)
	let giFlagsAddr = false
	CheckForAimSignIns(hwnd)
	let winclass = GetWindowClass (hWnd)
	
	if WinClass == wc_TMsgEditor
		|| WinClass == wc_TMsgRedirector
		then
		HandlingTheScheme ("TheBatOpenEditor")
		let gbNotSayLine = true
		return
	endif
	WindowActivatedEvent(hWnd)
EndFunction

void function SayWindowTypeAndText(handle hWnd)
	var string WinClass = GetWindowClass (hWnd)
	;if !InHomeRowMode() then
	;SayDebugger("SayWindowTypeAndText",hWnd)
	;EndIf
	builtin::SayWindowTypeAndText(hWnd)
	if (WinClass == wc_TMsgEditor
		|| WinClass == wc_TMsgRedirector)
		&& (GetWindowClass (GetCurrentWindow ()) != wc_TMicroEdW)
		then
		SayLine ()
	endif
EndFunction

Void Function DocumentLoadedEvent ()
	var
	string WinClass,
	handle hWnd
	;sayinteger (14)
	let hWnd = GetFocus ()
	let WinClass = GetWindowClass (hWnd)
	if winclass == globalwinclass then
		if (GetWindowClass (GetRealWindow (hwnd)) == wc_TMsgListViewer) && (GetCurrentScriptKeyName () == cksEnter) && GlobalMessageSayall == 2 then
			if !GetJCFOptionFromFile (OutputModesJCF, DocumentName) then
				IniWriteString (OutputModesJCF, DocumentName, sFlagsDocumentName, GetActiveConfiguration () +jcfFileType,true)
			endif
		endif
	endif
	Delay (5);Wait to check focus.
	if GetJCFOption(OPT_AUTO_FORMS_MODE) == 0
		&& GetJCFOption(optFormsModeAutoOff) == 1 then
		TurnOffFormsMode()
	EndIf
	if BackForward == 1 then
		SayLine()
		let BackForward=0
		return
	endIf
	let gbDocumentLoadAppAlertShowing = ProcessDocumentLoadAppAlerts()
	if !gbDocumentLoadAppAlertShowing then
		if !gbNotRepeatRow then
			DoDefaultDocumentLoadActions()
		endif
		let gbNotRepeatRow = false
		
		;otherwise DoDefaultDocumentLoadActions is called when the user buffer is dismissed
	EndIf
EndFunction

void function DoDefaultDocumentLoadActions()
	var
	string sClass,
	string sWindowName
	setJCFOption (OPT_QUICK_KEY_NAVIGATION_MODE, GetNavigationQuickKeysSettingFromFile ())
	if ShouldCheckForCustomPageSummary()
		&& GetJCFOption(OPT_CUSTOM_PAGE_SUMMARY) then
		CustomPageSummaryReported()
		return
	EndIf
	if DocumentLoadedAtFormField() then
		return
	EndIf
	let giLastDocumentLoadTime=GetTickCount()
	let sClass=GetWindowClass(GetFocus())
	let sWindowName =GetWindowName(GetCurrentWindow ())
	if sClass==cwcChromeBrowserClass then
		PCCursor()
		if IsVirtualPCCursor()
			&& !SayAllInProgress() then
			;		AnnounceDocumentElements()
			if gbDefaultSayAllOnDocumentLoad
				|| GetJCFOption(OPT_AUTO_SPEAK_WEB_PAGES)
				;		 ensure dialogs read using sayAll
				|| dialogActive () then
				if ((GetWindowClass (GetRealWindow (GetCurrentWindow ())) == wc_TMailerForm) || (GetWindowClass (GetRealWindow (GetCurrentWindow ())) == wc_TMsgListViewer)) && (GetCurrentScriptKeyName () == cksTab) && !GlobalMessageSayall
					|| ((GetWindowClass (GetRealWindow (GetCurrentWindow ())) == wc_TMsgListViewer)) && (GetCurrentScriptKeyName () == cksEnter) && GlobalMessageSayall == 2
					then
					JAWSTopOfFile ()
					QueueFunction( "SayAll()" );
					return
				endif
			EndIf
		endIf
	endIf
EndFunction

Int Function GetColumnsNumberInFoldersOrList (handle hWnd)
	var
	int l, int t, int r, int b, int w, int h,
	int lText, int tText, int wText, int hText,
	int iListItem, int iColumn, int iTemp,
	int nMaxCols, int nPrevMaxCols, int i,
	string WinClass,
	object oListItem, object oMaxCols
	
	let WinClass = GetWindowClass (hWnd)
	if WinClass == wc_TXTreeView then
		let oListItem = GetObjectFromEvent (hWnd, objid_client, 0, iListItem)
		oListItem.accLocation(Intref(lText), Intref(tText), Intref(wText), Intref(hText), iListItem)
		let tText = tText +1
		
		let iColumn = iColumn -1
		let oMaxCols = GetObjectFromEvent (hwnd, objid_client, ~iColumn, iTemp)
		oMaxCols.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), iTemp)
		let l = l +1
		let r = l +w
		let t = t +1
		let b = t + h
		var string sHeader
		While (~nMaxCols != nPrevMaxCols) && i < 20
			;let sHeader = sHeader +"|" +GetTextInRect (l, t, r, b, 0, IgnoreColor, IgnoreColor, 0, 0)
			let i = i +1
			let nPrevMaxCols = ~nMaxCols
			let oMaxCols = GetObjectFromEvent (hwnd, objid_client, ~(nmaxCols+1), iTemp)
			oMaxCols.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), iTemp)
			let l = l +1
			let r = l +w
			let t = t +1
			let b = t + h
			;let sHeader = sHeader +"|" +GetTextInRect (l, t, r, b, 0, IgnoreColor, IgnoreColor, 0, 0)
			if w < wText then
				let nMaxCols = ~iTemp
			endif
			if IsKeyWaiting () then
				;delay(1)
				return
			endif
		EndWhile
	endif
	;sayinteger(i)
	;saystring(sHeader)
	return (nMaxCols +1)
EndFunction

Void Function SaveChosenSettings ()
	var
	Int iSetting
	let TheBatConfigurationFileName = GetActiveConfiguration () + jcfFileType
	let iSetting = IniReadInteger (PathOptionsSectionName, flg_MessageHeaders , 0, TheBatConfigurationFileName)
	If GlobalSayMessageHeaders != iSetting then
		IniWriteInteger (PathOptionsSectionName, flg_MessageHeaders , GlobalSayMessageHeaders, TheBatConfigurationFileName)
	EndIf
	let iSetting = IniReadInteger (PathOptionsSectionName, flg_MessageSayAllKeys, 0, TheBatConfigurationFileName)
	If GlobalMessageSayAllKeys != iSetting then
		IniWriteInteger (PathOptionsSectionName, flg_MessageSayAllKeys, GlobalMessageSayAllKeys, TheBatConfigurationFileName)
	EndIf
EndFunction

Script AdjustJAWSOptions ()
	var
	String sPathNode,
	String sAllNodes
	
	let sPathNode = FormatString (MSG_SelectFunctionToRunItemsTemplate, sPathNode, FormatString (MSG_SelectFunctionToRunItemTemplate, SayAllAnnouncementFunctionName, SayAllAnnouncementItemName))
	let sPathNode = FormatString (MSG_SelectFunctionToRunItemsTemplate, sPathNode, FormatString (MSG_SelectFunctionToRunItemTemplate, HeadingsAnnouncementFunctionName, HeadingsAnnouncementItemName))
	ConvertListToNodeList (sPathNode, PathNodeName)
	ConvertListToNodeList (sPathNode, ApplicationNodeName)
	let sAllNodes = FormatString (MSG_SelectFunctionToRunItemsTemplate, sPathNode)
	OptionsTreeCore (sAllNodes, TRUE)
	SaveChosenSettings ()
EndScript

string function SayAllAnnouncementToggle (int iRetCurVal)
	If Not iRetCurVal then
		let GlobalMessageSayAllKeys = GlobalMessageSayAllKeys +1
		If GlobalMessageSayAllKeys >2 then
			let GlobalMessageSayAllKeys = 0
		endif
	EndIf
	If Not GlobalMessageSayAllKeys then
		Return (Msg_sayAllKeys_insert_Tab)
	Elif GlobalMessageSayAllKeys == 1 then
		Return (msg_Automatic_Reading)
	Elif GlobalMessageSayAllKeys == 2 then
		return (msg_AutomaticReading_Termination_Message)
	EndIf
EndFunction

string function SayAllAnnouncementToggleHlp (int iRetCurVal)
	Return (MSG_SayAllKeysAnnouncementHelp)
EndFunction

string function HeadingsAnnouncementToggle (int iRetCurVal)
	If Not iRetCurVal then
		let GlobalSayMessageHeaders = Not GlobalSayMessageHeaders
	EndIf
	If Not GlobalSayMessageHeaders then
		Return (msg_header_off)
	Else
		Return (msg_header_on)
	EndIf
EndFunction

string function HeadingsAnnouncementToggleHlp (int iRetCurVal)
	Return (MSG_HeadingsAnnouncementHelp)
EndFunction

Script ChoiceKeysForSayAll ()
	var
	String TheBatConfigurationFileName,
	Int iSetting,
	Int iResult,
	Int iChanged,
	handle hParentWindow,
	handle hWnd
	
	let hWnd = GetFocus ()
	let hParentWindow =FindWindow (GetRealWindow (hWnd), wc_TMessageListFrame, cscNull)
	let hParentWindow = FindWindow (hParentWindow, wc_TXTreeView, cscNull)
	if hParentWindow == hWnd
		let TheBatConfigurationFileName = GetActiveConfiguration () + jcfFileType
		Let GlobalMessageSayall = IniReadInteger (PathOptionsSectionName, Flg_MessageSayall, 0, TheBatConfigurationFileName)
		if GlobalMessageSayall == 2 then
			let GlobalMessageSayall = 0
			say (Msg_sayAll_TabKey, ot_line)
		elif not GlobalMessageSayall then
			let GlobalMessageSayall = 1
			say (Msg_sayAll_insert, ot_line)
		elif GlobalMessageSayall == 1 then
			let GlobalMessageSayall = GlobalMessageSayall +1
			say (Msg_sayAll_EnterKey, ot_line)
		endif
		IniWriteInteger (PathOptionsSectionName, Flg_MessageSayall, GlobalMessageSayall, TheBatConfigurationFileName)
	else
		SayCurrentScriptKeyLabel ()
	endif
	
EndScript

Void Function SayMessageHeaders (string sSearchOfHeading)
	var
	object oListItem,
	int iListItemCount, int iChild, int iTemp,
	string sValue, string sText,
	handle hMessageHeaders, handle hwnd
	let hwnd = GetCurrentWindow ()
	;saystring(globalwinclass)
	;saystring(GetWindowClass (hwnd))
	if GetWindowClass (hwnd) == globalWinClass then
		let hMessageHeaders = FindWindow (GetRealWindow (hwnd), wc_TMsgViewFrame, cscNull )
		delay(0, 1)
		let hMessageHeaders = FindWindow (hMessageHeaders, wc_TXTreeView, cscNull )
		
		SetFocus (hMessageHeaders)
		let oListItem = GetObjectFromEvent (hMessageHeaders, objid_client, CHILDID_SELF, iTemp)
		let iListItemCount = oListItem.AccChildCount
		let iChild = 1
		While (sSearchOfHeading != sText && iChild <= iListItemCount)
			let oListItem = GetObjectFromEvent (hMessageHeaders, objid_client, iChild, iTemp)
			oListItem.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
			let sText = oListItem.accname(iTemp)
			let iChild = iChild + 1
		EndWhile
		
		delay(1, 1)
		setFocus (GetFirstChild (hMessageHeaders))
		let oListItem = GetObjectFromEvent (GetFirstChild (hMessageHeaders), objid_client, CHILDID_SELF, iTemp)
		let sValue = oListItem.accValue(itemp)
		if !sValue then
			let sValue = oListItem.accName(itemp)
		endif
		let sText = sValue
		say(sText, ot_line)
		if globalwinclass == cwcChromeBrowserClass  then
			let gbNotRepeatRow = true
			let hWnd = FindWindow (GetRealWindow (hwnd), globalwinclass, cscNull )
			;saystring(globalwinclass)
			;saystring(GetWindowClass (hwnd))
		endif
		SetFocus (hWnd)
		;hMessageHeaders)
	endif
EndFunction

Int Function FindGraphickColorsMarkup (handle hWnd, int left, int top, int right, int bottom)
	var
	int iCurPixelY = GetCursorRow () -1,
	int iPixelForCheckingY = iCurPixelY -4,
	int iCurPixelX = GetCursorCol () -4,
	int iShiftX = 0,
	int IndexShiftX = ~(bottom -top>>1),
	string sChecked
	while IndexShiftX < iShiftX ;&& GetColorAtPoint (iCurPixelX +iShiftX, iCurPixelY ) == GetColorAtPoint (iCurPixelX +iShiftX, iPixelForCheckingY)
		let iShiftX = iShiftX -1
		if !(GetColorAtPoint (iCurPixelX +iShiftX, iCurPixelY ) == GetColorAtPoint (iCurPixelX +iShiftX, iPixelForCheckingY)) then
			let sChecked = cscChecked
			let iShiftX = IndexShiftX
		elif GetColorAtPoint (iCurPixelX +iShiftX, iCurPixelY ) == GetColorAtPoint (iCurPixelX +iShiftX, iPixelForCheckingY) then
			let sChecked = cscUnchecked
		endif
	endWhile
	delay(2, 1)
	say(sChecked, ot_Word)
	return true
EndFunction

Script GoToAttachment ()
	var
	object obj,
	int iChild,
	int iWindowAttach,
	handle hCurWindow,
	handle hWnd
	
	let hWnd = GetFocus()
	if IsMessageList (hWnd) then
		let hCurWindow= hWnd
		let obj = GetCurrentObject (iChild)
		if (msn_AttachField == StringSegment (obj.AccName(iChild), cscTab, StringSegmentIndex (obj.AccName(iChild), cscTab, msn_AttachField, true))
			|| msn_AttachFields == StringSegment (obj.AccName(iChild), cscTab, StringSegmentIndex (obj.AccName(iChild), cscTab, msn_AttachFields, true))) then
			let iWindowAttach = (msn_AttachField == StringSegment (obj.AccName(iChild), cscTab, StringSegmentIndex (obj.AccName(iChild), cscTab, msn_AttachField, true)) || msn_AttachFields == StringSegment (obj.AccName(iChild), cscTab, StringSegmentIndex (obj.AccName(iChild), cscTab, msn_AttachFields, true)))
		endif
		
		let hWnd = FindWindow (GetRealWindow (hWnd), wc_TListView, cscNull)
		if IsWindowVisible (hWnd) then
			SetFocus (hWnd)
			delay(5, 1)
			return
		elif !IsWindowVisible (hWnd) && iWindowAttach then
			say (msg_Window_With_Attachment_Is_Hidden, ot_line)
		else
			say (msg_NoAttachment, ot_line)
		endif
		var int l, int t, int r, int b, int w,int h
		obj.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), iChild)
		let l = (l +1) - GetWindowLeft (hCurWindow)
		let t = (t +1 +(h>>1)) - GetWindowTop (hCurWindow)
		;sayinteger(h>>1)
		delay(3)
		SendMessage(hCurWindow,wm_lbuttonDown, 0, MakeLong (l, t))
		SendMessage(hCurWindow,wm_lbuttonUp, 0, MakeLong (l, t))
		delay(2)
		TypeKey ("escape", 1)
		;FocusChangedEventEx (hCurWindow, -4, iChild, GlobalPrevFocus, -4, iChild, 6)
		delay(5)
		;SayTextItem (hCurWindow, obj, iChild)
		return
	endif
EndScript

Script StartLink (int iCopyKey)
	var
	object oItem, object oChildList,
	int iTemp, int nMaxCols, int iChild,
	string sLinkText, String sReg,
	handle hWnd,
	handle hCurrent
	
	let hCurrent = GetFocus ()
	let hWnd = FindWindow (GetRealWindow (hCurrent), wc_TMsgViewFrame, cscNull )
	let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
	SetFocus (hWnd)
	let oItem = GetObjectFromEvent (hWnd, objid_client, CHILDID_SELF, iTemp)
	let nMaxCols = oItem.AccChildCount
	
	SpeechOff ()
	let iChild = 1
	While (iChild <= nMaxCols) && (!StringContains (sLinkText, "://"))
		let oItem = GetObjectFromEvent (hWnd, objid_client, iChild, iTemp)
		oItem.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
		delay(1, 1)
		let oChildList = GetObjectFromEvent (GetFirstChild (hWnd), objid_client, CHILDID_SELF, iTemp)
		let sLinkText = StringSegment (oChildList.accName(iTemp), cscSpace,-1)
		let iChild = iChild + 1
	endWhile
	
	;From YuriS,      
	If !StringStartsWith (sLinkText, "http") Then
		If StringRight (StringSegment (sLinkText, "http", 1), 1) == "(" Then
			Let sLinkText = stringChopRight (sLinkText, 1)
		EndIf
		Let sLinkText = StringReplaceSubstrings (sLinkText, StringSegment (sLinkText, "http", 1), cscNull)
	EndIf
	
	SetFocus (hCurrent)
	StopSpeech ()
	SpeechOn ()
	;delay(3)
	if iCopyKey then
		If !StringStartsWith (GetClipboardText (), "http") Then
			CopyToClipboard (sLinkText)
		Else
			AppendToClipboard (sLinkText, 1)
		EndIf
		PlaySound (FindJAWSSoundFile ("Click.wav", 0))
	else
		if sLinkText then
			;From YuriS,   ,   . !GetRegistryEntryString()
			Let oItem = CreateObject("WScript.Shell")
			Let sReg = oItem.RegRead ("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice\\ProgId")
			Let sReg=oItem.RegRead("HKEY_CLASSES_ROOT\\" + sReg + "\\Shell\\Open\\Command\\")
			run (FormatString ("%1%2%3 %4", "\"", StringReplaceSubstrings (StringSegment (sReg, "\"", 2), "\\", "\\\\"), "\"", sLinkText)) ;("\"" + StringReplaceSubstrings (StringSegment (sReg, "\"", 2), "\\", "\\\\") + "\"" + cscSpace + sLinkText)
			HandlingTheScheme ("TheBatOpenRSS")
		endif
	endif
EndScript

Script OrderOfFoldersAndBoxes ()
	var
	int l, int t, int w, int h, int r, int b,
	int iTemp,
	object oClient,
	handle hParentWindow,
	handle hWnd
	
	let hwnd = GetFocus ()
	let hParentWindow =FindWindow (GetRealWindow (hWnd), wc_TFoldersFrame, cscNull)
	let hParentWindow = FindWindow (hParentWindow, wc_TXTreeView, cscNull)
	if hParentWindow == hWnd
		let oclient = GetObjectFromEvent (hwnd, objid_client, -1, itemp)
		oclient.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), itemp)
		let l = l +1
		let t = t +1
		let b = t+h
		let r = l + w
		
		PostMessage(hwnd,wm_lbuttonDown, 0, MakeLong ((r-l) >>1, (b-t) >>1))
		PostMessage(hwnd,wm_lbuttonUp, 0, MakeLong ((r-l) >>1, (b-t) >>1))
	else
		SayCurrentScriptKeyLabel ()
	endif
EndScript

Script SettingUpColumnsForFoldersAndBoxes (optional int flag)
	var
	int l, int t, int w, int h, int r, int b, int iTemp,
	object oClient,
	handle hWnd
	let hwnd = GetFocus ()
	if IsFolderList (hWnd) || IsMessageList (hWnd) then
		let oclient = GetObjectFromEvent (hwnd, objid_client, -1, itemp)
		oclient.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), itemp)
		if !h then
			say (" ", ot_line)
			return
		endif
		let l = l +1
		let t = t +1
		let b = t+h
		let r = l + w
		let l = (r-l) >>2
		let t = (b-t) >>1
		
		PostMessage(hwnd,wm_rbuttonDown, 0, MakeLong (l, t))
		PostMessage(hwnd,wm_rbuttonUp, 0, MakeLong (l, t))
		if !flag then
			if IsFolderList (hWnd) && !flag then
				TypeKey (cksEsc, 1)
				return
			endif
		else
			if IsFolderList (hWnd) then
				TypeKey (cksEsc, 1)
			elif IsMessageList (hWnd) then
				SpeechOff ()
				delay(2, 1)
				let oClient = GetCurrentObject (iTemp).AccNavigate(NavDir_LastChild, iTemp)
				oclient.accDoDefaultAction(itemp)
				delay(5)
				let hWnd = getCurrentWindow()
				let hWnd=FindWindow (hWnd, wc_TXTVCheckListBox, cscNull)
				SetFocus(hWnd)
				SpeechOn ()
			endif
			let globalprevClass = GetWindowClass (GetRealWindow (hWnd))
			return
		endif
	else
		SayCurrentScriptKeyLabel ()
	endif
EndScript

script ReadListviewColumn()
	var
	object oPage, object oListItem, object oMaxCols,
	int iPage, int iListItem,
	int iTemp, int nCol, int nMaxCols, int nPrevMaxCols,
	int l, int t, int w, int h, int r, int b,
	int lText, int tText, int wText, int hText, int rText, int bText,
	string sValue, string sText,
	handle hWindow,
	handle hCurrent,
	string WinClass
	
	let hCurrent = GetFocus ()
	if IsTrueListView(hCurrent) then
		PerformScript ReadListviewColumn()
	else
		let WinClass = GetWindowClass (hCurrent)
		
		let nCol=StringToInt(stringRight(GetCurrentScriptKeyName(),1))
		if IsSameScript () == 1 then
			if nCol == 0 then
				let nCol = 20
			else
				let nCol= nCol +10
			endif
		elif IsSameScript () == 2 then
			let nCol = nCol +30
		endif
		if nCol==0 then
			let nCol= 10
		endIf
		if (nCol < 1) then
			let nCol=1
		endIf
		
		if WinClass == wc_TAddressBookGrid then
			delay(2)
			let opage = GetObjectFromEvent (hCurrent, objid_hscroll, 2, ipage)
			While (oPage.accstate(iPage) != STATE_SYSTEM_INVISIBLE)
				opage.AccDoDefaultAction(ipage)
			EndWhile
			
			let hWindow = FindWindow (GetRealWindow (hCurrent), wc_THeaderControl, cscNull)
			let nCol = nCol + 1
			let oListItem = GetObjectFromEvent (hWindow, OBJID_client, nCol, iTemp)
			oListItem.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
			oListItem.acclocation(intref(l), intref(t), intref(w), intref(h), iTemp)
			let L = L + 1
			let R = L + W
			let nMaxCols = oListItem.AccChildCount
			let opage = GetObjectFromEvent (hCurrent, objid_hscroll, 4, ipage)
			While (opage.accstate(ipage) != STATE_SYSTEM_INVISIBLE || oListItem.accstate(itemp) & STATE_SYSTEM_INVISIBLE)
				&& (GetWindowRight (hWindow) < r)
				if IsKeyWaiting () then
					return
				endif
				opage.AccDoDefaultAction(ipage)
				let oListItem = GetObjectFromEvent (hWindow, OBJID_client, nCol, iTemp)
				oListItem.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
				oListItem.acclocation(intref(l), intref(t), intref(w), intref(h), iTemp)
				let L = L + 1
				let R = L + W
				delay(1)
				if !sText then
					let sText = GetTextInRect (l, giCurTop, r, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
				elif GetTextInRect (l, GetLinetop (), r, GetLineBottom (), 0, ignorecolor, ignorecolor, 0, 0) then
					let sText = GetTextInRect (l, giCurTop, r, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
				endif
			endwhile
			let nMaxCols  = nMaxCols  -1
			let nCol = ncol -1
			let sValue = oListItem.accname(iTemp)
			say (sValue, ot_line)
			if !sText then
				let sText = GetTextInRect (l, giCurTop, r, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
			endif
			if !sText && sValue then
				if FindGraphickColorsMarkup (hCurrent, l, giCurTop, r, giCurBottom) then
				else
					say (cscSpace, ot_line)
				endif
				return
			else
			endif
			let opage = GetObjectFromEvent (hCurrent, objid_hscroll, 2, ipage)
			While (oPage.accstate(iPage) != STATE_SYSTEM_INVISIBLE)
				opage.AccDoDefaultAction(ipage)
			EndWhile
			
		elif WinClass == globalWinClass then
			let hCurrent = FindWindow (FindTopLevelWindow (GetWindowClass (GetRealWindow (hCurrent)), GetWindowName (GetRealWindow (hCurrent))), wc_TMsgViewFrame, cscNull )
			let hCurrent = FindWindow (hCurrent, wc_TXTreeView, cscNull )
			SetFocus (hCurrent)
			
			let oListItem = GetObjectFromEvent (hCurrent, objid_client, CHILDID_SELF, iTemp)
			let nMaxCols = oListItem.AccChildCount
			if nCol <= nMaxCols then
				let oListItem = GetObjectFromEvent (hCurrent, objid_client, nCol, iTemp)
				oListItem.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
				;let sText = oListItem.accname(iTemp)
				
				delay(1,1)
				let oListItem = GetObjectFromEvent (GetFirstChild (hCurrent), objid_client, CHILDID_SELF, iTemp)
				let sValue = oListItem.accValue(itemp)
				if !sValue then
					let sValue = oListItem.accName(itemp)
				endif
				let sText = sValue
				;sText +cscBufferNewLine +
			endif
			let hCurrent = FindWindow (FindTopLevelWindow (GetWindowClass (GetRealWindow (hCurrent)), cscNull), wc_TMsgViewFrame, cscNull )
			SetFocus (hCurrent)
			let hCurrent = FindWindow (hCurrent, globalwinclass, cscNull )
			SetFocus (hCurrent)
			if GetWindowClass (hCurrent) == cwcChromeBrowserClass  then
				if IsWindowObscured (hCurrent) then
					let hCurrent = FindWindow (GetRealWindow (hCurrent), wc_TMsgViewFrame, cscNull)
					let hCurrent = FindWindow (hCurrent, wc_TChromiumMessageFrame, cscNull)
					let hCurrent = FindWindow (GetNextWindow (GetParent (hCurrent)), cwcChromeBrowserClass , cscNull)
				endif
				let gbNotRepeatRow = true
			endif
			SetFocus (hCurrent)
			delay (1)
			
		elif WinClass == wc_TXTreeView then
			delay (2)
			let opage = GetObjectFromEvent (hCurrent, objid_hscroll, 2, ipage)
			While (oPage.accstate(iPage) != STATE_SYSTEM_INVISIBLE)
				opage.AccDoDefaultAction(ipage)
			EndWhile
			
			let oListItem = GetFocusObject (iListItem)
			oListItem.accLocation(Intref(lText), Intref(tText), Intref(wText), Intref(hText), iListItem)
			let tText = tText +1
			let bText = tText + hText
			
			let nCol = nCol -1
			let oMaxCols = GetObjectFromEvent (hCurrent, objid_client, ~nCol, iTemp)
			oMaxCols.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), iTemp)
			let l = l+1
			let r = l + w
			let t = t + 1
			let b = t + h
			let sValue = GetTextInRect (l, t, r, b, 0, ignorecolor, ignorecolor, 0, 0)
			let sText = GetTextInRect (l, tText, r, bText, 0, ignorecolor, ignorecolor, 0, 0)
			
			While (~nMaxCols != nPrevMaxCols) && w < wText
				let nPrevMaxCols = ~nMaxCols
				let oMaxCols = GetObjectFromEvent (hCurrent, objid_client, ~(nmaxCols+1), iTemp)
				oMaxCols.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), iTemp)
				if w < wText then
					let nMaxCols = ~iTemp
				endif
				if IsKeyWaiting () then
					return
				endif
			EndWhile
			
			let opage = GetObjectFromEvent (hCurrent, objid_hscroll, 4, ipage)
			While (oPage.accstate(iPage) != STATE_SYSTEM_INVISIBLE)
				opage.AccDoDefaultAction(ipage)
				let oMaxCols = GetObjectFromEvent (hCurrent, objid_client, ~nCol, iTemp)
				oMaxCols.accLocation(Intref(l), Intref(t), Intref(w), Intref(h), iTemp)
				let l = l+1
				let r = l + w
				let t = t + 1
				let b = t + h
				if w > 0 then
					let sValue = sValue + GetTextInRect (l, t, r, b, 0, ignorecolor, ignorecolor, 0, 0)
					let sText = sText + GetTextInRect (l, tText, r, bText, 0, ignorecolor, ignorecolor, 0, 0)
				endif
			endwhile
			
			let sText =sValue + sText
			
			let opage = GetObjectFromEvent (hCurrent, objid_hscroll, 2, ipage)
			While (oPage.accstate(iPage) != STATE_SYSTEM_INVISIBLE)
				opage.AccDoDefaultAction(ipage)
			EndWhile
			let nMaxCols = nMaxCols +1
			let nCol = nCol +1
		endif
		
		if (nCol > nMaxCols) then
			SayFormattedMessage(OT_ERROR,formatString(cmsgListviewContainsXColumns_L,intToString(nCol),intToString(nMaxCols)),formatString(cmsgListviewContainsXColumns_S,intToString(nCol)))
			return
		endIf
		say(sText,OT_NO_DISABLE)
	endif
endScript

Void Function GetObjectText (object o, int iChild, string ByRef sTextRec)
	Var
	Int left, Int Top, Int width, Int height, Int right, Int Bottom,
	string sName,
	handle hWnd
	let hWnd = GetCurrentWindow ()
	GetObjectRect (left, right, top, bottom, true, 0)
	let sName = o.AccName(iChild)
	
	if sName && !gi_HeaderReadListOrFolder
		&& (IsFolderList (hWnd)|| IsMessageList (hWnd)
		|| GetWindowClass (GetAppMainWindow (hWnd)) == wc_TMsgListViewer)
		then
		let sTextRec =sName
	else
		let sTextRec = GetTextInRect (left, top, right, bottom, 0, ignorecolor, ignorecolor, 0, 0)
		let sTextRec = FormatString("%1 %2", sTextRec, StringSegment (sName, ";", 2))
	endif
EndFunction

Script test ()
	;globalprevClass = cscnull
	;gs_MsaaHeaderRead =cscnull
	;  	 			-		[A-C]   		13  2022, 21:02		13  2022, 21:02
	;  	 			 	 		i_anat@inbox.ru		  .		13  2022, 19:30		13  2022, 19:31
	;  					 	 		i_anat@inbox.ru		  .		19:30		19:31
	var
	int iChild,
	string sName = GetCurrentObject (iChild).AccName(iChild),
	string sh ="||||",
	stringArray num_1, int j,
	int i, string sHeader, string sTemp, int h
	
	;sayinteger(giColumCaunt && gi_HeaderReadListOrFolder)
	;saystring(StringDiff ("  ", " "))
	;saystring(sHeader)
	CopyToClipboard (StringReverse ("e82c8d6"))
	saystring(StringReverse ("e82c8d6"))
	;sayinteger(StringContains(" 	 				 	 		i_anat@inbox.ru		  .		18:35		18:35", ""))
	
	;saystring(getRoleText (oHeader.accrole(itemp)))
	;saystring(oHeader.accName(itemp))
	
	;sayinteger(0xE*2, 16)
	saystring(GetCurrentSchemeName ())
	/*
	var object GoUIA = CreateObjectEx ("freedomsci.UIA", false, "UIAScriptAPI.x.manifest"),
	Object oFocus = goUIA.GetFocusedElement (),
	Object oWalker = goUIA.ContentViewWalker,
	object o,
	Int i, Int ic, string s1, string s2,
	Int l, Int t, Int r, Int b, handle hwnd = getCurrentWindow ()
	let o = GetCurrentObject (ic)
	sayinteger(o.accstate(ic) & STATE_SYSTEM_CHECKED)
	let ic = StringSegmentCount (s1, " ")
	sayinteger(ic)
	while i <= ic
	TypeString (StringSegment (s1, " ", i))
	TypeKey ("enter", 1)
	let i = i + 1
	endwhile
	;sayinteger(StringContains (s1, StringSegment (s2, " ", 1)))
	;StringReverse (StringDiff (StringReverse ("  "), StringReverse (" "))))
	*/
EndScript

Script test1 ()
	var
	object oclient,
	int iclient,
	string st, string sl,
	int l, int t, int w, int h, int r, int b,
	int i, int ih, int ic, object oc, object oh, handle hw
	
	CopyToClipboard (" ")
EndScript

Void Function SayButton (handle hWnd)
	var
	int iHierarchyX,
	string sRealClass
	
	let sRealClass = GetWindowClass (GetRealWindow (hWnd))
	SaveCursor ()
	InvisibleCursor ()
	SaveCursor ()
	RouteInvisibleToPc ()
	if GetGraphicID ()
		&& (sRealClass == wc_TfrmCustomizer2)
		then
		let iHierarchyX = GetWindowHierarchyX (hwnd)
		if iHierarchyX == 1 then
			say (msg_add_container, ot_line)
		elif iHierarchyX == 2 then
			say (msg_element_down, ot_line)
		elif iHierarchyX == 3 then
			say (msg_element_up, ot_line)
		elif iHierarchyX == 4 then
			say (msg_delimiter, ot_line)
		elif iHierarchyX == 5 then
			say (msg_remove_item, ot_line)
		elif iHierarchyX == 6 then
			say (msg_add_item, ot_line)
		endif
	endif
	RestoreCursor ()
	RestoreCursor ()
	
	if sRealClass == wc_TAddressSelector then
		if GetWord () == cScLess2 then
			say (msg_clear_field, ot_line)
		elif GetWord () == cScLess then
			say (msg_Remove, ot_line)
		elif GetWord () == cScLess3 then
			say (msg_Clear_all_fields, ot_line)
		elif GetWord () == cScGreater then
			say (msg_add, ot_line)
		elif GetWord () == cScGreater2 then
			say (msg_Add_all, ot_line)
		elif GetWord () == cscQuestionMark then
			say (msg_work_list_divided, ot_line)
		endif
	endif
	
	if sRealClass == wc_TColumnSetup then
		if GetWord () == cScLess2 then
			say (msg_clear_entire_list, ot_line)
		elif GetWord () == cScLess then
			say (msg_Remove_item_from_list, ot_line)
		elif GetWord () == cScGreater then
			say (msg_Add_item_list, ot_line)
		elif GetWord () == cScGreater2 then
			say (msg_Add_entire_list, ot_line)
		endif
	endif
	return
EndFunction

Script SayLine ()
	var
	object oListItem,
	int iChild,
	int iChildcount,
	handle hwnd,
	int TheTypeCode,
	string sTextRec,
	string strVal,
	string sClass
	
	let globalMessageList = Null ()
	let hwnd = GetFocus ()
	let sClass = GetWindowClass (hWnd)
	
	if UserBufferIsActive () && IsVirtualPCCursor () then
		Say (GetLine (), ot_line, 1)
		return
	endif
	
	If IsSameScript()
		&& !IsMessageList (hwnd)
		&& !IsFolderList (hwnd)
		&& sClass != wc_TListView
		&& sClass != wc_TXTreeView
		&& sClass != wc_TXTVCheckListBox
		&& sClass != wc_TListBox
		then
		SpellLine()
		Return
	EndIf
	If !IsPcCursor()
		|| IsVirtualPcCursor() then
		SayLine ()
		Return
	EndIf
	If GlobalMenuMode then
		if globalMenuMode==MENU_ACTIVE then
			let sClass=GetWindowClass(GetParent(GetFocus()))
			if StringContains(sClass,cwcXPStartMenuParentClassSubstring) then
				sayObjectActiveItem()
				return
			endIf
		endIf
		sayObjectActiveItem()
		Return
	EndIf
	
	
	Let TheTypeCode = GetWindowSubTypeCode (hwnd)
	If !TheTypeCode then
		Let TheTypeCode = GetObjectSubTypeCode (true)
	EndIf
	
	If TheTypeCode == WT_TREEVIEW
		then
		Let strVal = GetObjectValue ()
		If ! strVal then
			Let strVal = GetObjectName (true)
		EndIf
		;SayObjectTypeAndText ()
		;	Return
	EndIf
	
	let oListItem = GetCurrentObject (iChild)
	let iChildcount = oListItem.AccChildcount
	if IsMessageList (hwnd) || IsFolderList (hwnd)
		|| GetWindowClass (GetRealWindow (hWnd)) == wc_TFolderSelector
		|| (sClass == wc_TListView && GetWindowClass (GetParent (hwnd)) != wc_TTabSheet)
		then
		delay(2)
		if IsSameScript () then
			if !IsFolderList (hwnd)
				&& GetWindowClass (GetAppMainWindow (hWnd)) != wc_TMsgListViewer
				then
				let iChild = oListItem.accNavigate(NavDir_LastChild, iChild)
				if iChild > iChildcount then
					let hWnd = FindWindow (GetRealWindow (hWnd), wc_TFoldersFrame , cscNull)
					let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
					if hwnd then
						SetFocus (hwnd)
						SpeechOff ()
						TypeKey (cksControlR, 1)
						delay(2)
					endif
					let hWnd = FindWindow (GetRealWindow (hWnd), wc_TMessageListFrame, cscNull)
					let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
					SetFocus (hwnd)
					delay (2)
				endif
				let oListItem = GetCurrentObject (iChild)
				let iChildcount = oListItem.AccChildcount
			endif
			SpeechOn ()
			say(FormatString (Msg_elem_List1, IntToString (iChild), IntToString (iChildcount)), ot_line)
			return
		endif
	endif
	
	if (GetWindowClass (GetRealWindow (hWnd)) == wc_TGlobalPrefDlg
		|| GetWindowClass (GetRealWindow (hWnd)) == wc_TFolderSelector
		|| GetWindowClass (GetRealWindow (hWnd)) == wc_TExtSetup
		||GetWindowClass (GetRealWindow (Hwnd)) == wc_TAddrHistoryScanner
		||GetWindowClass (GetRealWindow (Hwnd)) == wc_TImapNewFolderManager)
		&& sClass == wc_TXTreeView
		then
		GetObjectText (oListItem, iChild, sTextRec)
		Say (sTextRec, ot_line)
	endif
	
	if sClass == wc_TEdit
		|| sClass == wc_TMicroEdW
		|| sClass == wc_TViewerCss
		|| sClass == wc_TRichViewEdit
		|| sClass == wc_TXTRichEdit
		|| sClass == wc_TRichEdit
		|| sClass == wc_TRichView
		then
		SayLine ()
		return
	elIf IsMessageList (hWnd) || IsFolderList (hWnd) then
		MSAARefresh (true, 1)
		let sTextRec = oListItem.AccName(iChild)
		if not sTextRec then
			GetObjectText (oListItem, iChild, sTextRec)
		endif
		say(sTextRec, ot_Line)
		return
	endif
	
	if (sClass == wc_TListView && GetWindowClass (GetRealWindow (Hwnd)) == wc_TGlobalPrefDlg) then
		if IsSameScript () then
			say(FormatString (Msg_elem_List1, IntToString (iChild), IntToString (iChildcount)), ot_line)
		else
			SayObjectTypeAndText ()
		endif
		return
	endif
	
	if TheTypeCode== WT_COMBOBOX  && sClass ==wc_ComboBox
		&&GetWindowClass (GetRealWindow (hwnd)) == wc_TGlobalPrefDlg
		then
		say (GetTextInWindow (hwnd), ot_line)
		return
	endif
	
	if GetWindowClass (GetRealWindow (hWnd)) == wc_TInstallSelectAccounts
		&& sClass == wc_TXTVCheckListBox then
		say (GetWindowText (hWnd, true), ot_line)
		return
	endif
	
	
	if sClass == wc_TAddressBookGrid then
		ReadTheDestinationCell (hWnd, giCurTop, giCurBottom, giCurColumn)
		return
	else
		if IsSameScript () then
			say(FormatString (Msg_elem_List1, IntToString (iChild), IntToString (iChildcount)), ot_line)
		else
			SayObjectTypeAndText (0)
		endif
		return
	endif
	if TheTypeCode == WT_HOTKEY then
		SayWindowTypeAndText (hwnd)
		return
	endif
EndScript

Void Function SayLine (optional Int iDrawHighlights, optional int bSayingLineAfterMovement)
	var
	int iData,
	object OHider,
	;string sNameH,
	string sName,
	handle hwnd,
	string WinClass,
	;   .
	String sLine, String sSegm,
	String sTmp, Int i, stringArray sMailOrLink
	
	let hwnd = GetFocus ()
	let WinClass = GetWindowClass (hwnd)
	If (WinClass == wc_TMicroEdW)
		&& IsPCCursor ()
		Let sLine = GetLine ()
		If StringContains (sLine, "@")
			|| StringContains (sLine, "http:") || StringContains (sLine, "https:")
			|| StringContains (sLine, "www.") Then
			let sMailOrLink = new StringArray[StringSegmentCount (sLine, cScSpace)	]
			for i = 1 To StringSegmentCount (sLine, cScSpace)
				Let sSegm = StringSegment (sLine, cscSpace, i)
				;				sayinteger(i)
				If StringContains (sSegm , "@") && StringContains (sSegm , cscPeriod) Then
					Let sTmp = FormatString ("%1 %2", cMailLink, sSegm)
					Let sMailOrLink[i] = sTmp
				elif StringStartsWith (sSegm, "http:", 0) || StringStartsWith (sSegm, "https:", 0)
					|| StringStartsWith (sSegm, "www.", 0) Then
					Let sTmp = FormatString ("%1 %2", cURL, sSegm)
					Let sMailOrLink[i] = sTmp
				else
					Let sMailOrLink[i] = sSegm
				EndIf
				If IsKeyWaiting () Then
					Return
				EndIf
			EndFor
			for i = 1 To StringSegmentCount (sLine, cScSpace)
				Say (sMailOrLink[i], ot_line)
				If IsKeyWaiting () Then
					Return
				EndIf
			EndFor
			Return
		EndIf
	EndIf
	
	if (WinClass == wc_TXTRichEdit)
		;&& IsPCCursor ()
		;&& CaretVisible ()
		then
		let OHider = GetCurrentObject (iData)
		let sName = OHider.AccName(idata)
		say (sname, ot_Control_type)
		IndicateControlType(GetWindowSubTypeCode (hwnd),cscNull,cscNull)
		return
	endif
	SayLine (iDrawHighlights, bSayingLineAfterMovement)
EndFunction

void function SayLineUnit(int unitMovement, optional int bMoved)
	var
	object ohScroll, object oText, string sText, string sVal, string sTextScroll,
	int iChild, int iState, int iSegment, int iNum, int itext, int itextScroll ,
	int l, int r, int t, int b, int w, int h,
	int iTopPiksel,
	handle hHeaderWindow,
	handle hCurrentWindow,
	handle hRWnd,
	string sWRealClass,
	string WinClass
	
	let gbNullChar = false
	if 	UserBufferIsActive () && IsVirtualPCCursor () then
		SayLine ()
		return
	endif
	
	let hCurrentWindow = GetCurrentWindow()
	let WinClass = GetWindowClass (hCurrentWindow)
	let hRWnd = GetRealWindow (hCurrentWindow)
	let sWRealClass = GetWindowClass (hRWnd)
	
	if (sWRealClass == wc_TMsgEditor
		|| sWRealClass == wc_TMsgRedirector)
		&& WinClass == wc_TXTRichEdit
		then
		delay (2)
		SayLine ()
		return
	endif
	
	if IsPCCursor () && (WinClass == wc_TMicroEdW)
		&& unitMovement == UnitMove_Next then
		PostMessage (hCurrentWindow, wm_VSCROLL, 1)
		delay(1)
	endif
	
	if winClass == wc_TMsgEditor
		|| winClass == wc_TMsgRedirector
		then
		delay (2)
		if !gbNotSayLine
			|| !SendMessage (hCurrentWindow, WM_GetTextLength)
			then
			return
		endif
	endif
	
	if GetWindowClass (GetRealWindow (hCurrentWindow)) == wc_TFmMessageDelay &&
		WinClass == wc_TDateTimePicker then
		var int iLength
		let oText= GetFocusObject(iText)
		let sText = oText.AccName(iText)
		let iLength = SendMessage (hCurrentWindow, wm_GetTextLength, 0, 0)
		;StringLength (sText)
		
		delay(1)
		if StringContainsChars (sText, cScPeriod)  then
			let GlobalPrevDate = sText
		elif StringContainsChars (sText, cScColon)  then
			let GlobalPrevTime = sText
		endif
		return
	endif
	
	SayLineUnit(unitMovement, bMoved)
	var
	int iTemp,
	object oVScroll
	if WinClass == wc_TAddressBookGrid
		&& sWRealClass != wc_TMessageFinder then
		let oText = GetCurrentObject (iChild)
		if !(oText.AccName(iChild)) then
			nextline()
			nextline()
			priorLine()
			;endif
			let iTopPiksel = (GetLineTop () -GetWindowTop (hCurrentWindow)) +3
			PostMessage (hCurrentWindow, wm_lbuttonDown, 0, MakeLong (0, iTopPiksel))
			PostMessage (hCurrentWindow, wm_lbuttonUp, 0, MakeLong (0, iTopPiksel))
			TypeKey (cksEsc, 1)
		endif
		let giCurTop = GetLineTop ()
		let giCurBottom = GetLineBottom ()
		ReadTheDestinationCell (hCurrentWindow, giCurTop, giCurBottom, giCurColumn)
		return
	endif
	if IsFolderList (hCurrentWindow) || IsMessageList (hCurrentWindow) then
		if unitMovement == 1 then
			let iChild = 5
		elif unitMovement == 2 then
			let iChild = 1
		endif
		let oVScroll = GetObjectFromEvent (hCurrentWindow, objid_vscroll, iChild, iTemp)
		oVScroll.AccDoDefaultAction(iTemp)
		delay(3)
		return
	endif
	if WinClass == wc_TComboBox && GetWindowClass (GetPriorWindow (hCurrentWindow)) == WinClass then
		if GetWindowHierarchyX (hCurrentWindow) == GetWindowHierarchyX (GetLastWindow (hCurrentWindow)) then
			let oText = GetCurrentObject (iText)
			let sVal = oText.AccValue(iText)
			say(sval, ot_line)
		endif
	endif
EndFunction

void function HomeEndMovement(int UnitMovement)
	var
	object oHead,
	int iTemp,
	int iChildCount,
	handle hHeaderWindow,
	handle hWnd
	HomeEndMovement(UnitMovement)
	let hWnd = GetFocus ()
	if GetWindowClass (hWnd) == wc_TAddressBookGrid then
		let hHeaderWindow = FindWindow (GetRealWindow (hWnd), wc_THeaderControl, cscNull)
		let oHead = GetObjectFromEvent (hHeaderWindow, objid_client, childID_Self, iTemp)
		let iChildCount = oHead.AccChildCount
		if UnitMovement ==UnitMove_Last then
			let giCurColumn= iChildCount
		elif UnitMovement == UnitMove_First then
			let giCurColumn= 2
		endif
		ReadTheDestinationCell (hWnd, giCurTop, giCurBottom, giCurColumn)
		return
	endif
EndFunction

void function SayTopBottomUnit(int UnitMovement)
	var
	int iSubtype,
	object oHead,
	int iTemp,
	int iChildCount,
	handle hHeaderWindow,
	int iTopPiksel,
	handle hWnd
	let hWnd = GetFocus ()
	if SupportsEditCallbacks() then ;CaretMovedEvent will speak
		return
	EndIf
	let iSubtype = GetObjectSubtypeCode()
	if (iSubtype == wt_ListView
		|| iSubtype == wt_ListBox
		|| iSubtype == wt_ListBoxItem
		|| iSubtype == wt_ExtendedSelect_ListBox
		|| iSubtype == wt_MultiSelect_ListBox
		|| iSubtype == wt_TreeView
		|| iSubtype == wt_TreeViewItem
		|| IsVirtualRibbonActive())
		&& GetWindowClass (hWnd) != wc_TAddressBookGrid then
		return
	EndIf
	delay (1)
	if IsVirtualPCCursor () then
		SayLine ()
		return
	endIf
	if UnitMovement == UnitMove_Top then
		SayMessage(ot_JAWS_message, cmsg36_L, cmsg36_S) ;"top of file"
	ElIf UnitMovement == UnitMove_Bottom then
		SayMessage(ot_JAWS_message, cmsg37_L, cmsg37_S) ;"bottom of file"
	EndIf
	if GetWindowClass (hWnd) == wc_TAddressBookGrid then
		SpeechOff ()
		let hHeaderWindow = FindWindow (GetRealWindow (hWnd), wc_THeaderControl, cscNull)
		let oHead = GetObjectFromEvent (hHeaderWindow, objid_client, childID_Self, iTemp)
		let iChildCount = oHead.AccChildCount
		if UnitMovement == UnitMove_Top then
			;sayinteger(GetLineTop ())
			let giCurColumn= 2
		ElIf UnitMovement == UnitMove_Bottom then
			JAWSHome ()
			PriorLine ()
			NextLine ()
			let giCurColumn= iChildCount
			JAWSEnd ()
		endif
		;sayinteger(GetLineTop ())
		SpeechOn ()
		let giCurTop = GetLineTop ()
		let giCurBottom = GetLineBottom ()
		ReadTheDestinationCell (hwnd, giCurTop, giCurBottom, giCurColumn)
		return
	endif
	SayLine()
	;SayTopBottomUnit(UnitMovement)
EndFunction

Void Function SayCharacterUnit (int UnitMovement)
	var
	object oCaret,
	int iCaret,
	int lc, int tc, int wc, int hc, int bc, int rc,
	int iChildCount,
	int iLengthLine,
	string WinClass,
	handle hHeaderWindow,
	handle hWnd
	
	let hWnd=GetFocus()
	let WinClass = GetWindowClass (hwnd)
	
	if IsJAWSCursor () || UserBufferIsActive () then
		SayCharacterUnit (UnitMovement)
	else
		if GetWindowClass (GetRealWindow (hWnd)) == wc_TSmartBat then
			if WinClass == wc_TPageControl then
				let oCaret = GetCurrentObject (iCaret)
				let iChildCount = oCaret.accChildCount
				if iChildCount == 4 then
					if iCaret == 1 then
						oCaret.accDoDefaultAction(2)
					else
						oCaret.accDoDefaultAction(1)
					endif
				endif
			endif
		endif
		
		if ((WinClass == wc_TRichViewEdit)
			|| (winClass == wc_TMicroEdW))
			then
			if GetCharacter () == cscNull then
				if !gbNullChar then
					let gbNullChar = true
				elif UnitMovement == UnitMove_Next then
					let gbNullChar = false
					let oCaret = GetObjectFromEvent (hwnd, objid_caret, 0, iCaret)
					oCaret.AccLocation(intref(lc), intref(tc), intref(wc), intref(hc), iCaret)
					let tc = tc+1
					let bc = tc+hc
					PostMessage(hwnd,wm_lbuttonDown, 0, MakeLong (0, bc-GetWindowTop (hwnd )))
					PostMessage(hwnd,wm_lbuttonUp, 0, MakeLong (0, bc-GetWindowTop (hwnd)))
				endif
				if UnitMovement == UnitMove_Prior then
					let gbNullChar = false
					PriorCharacter ()
					NextCharacter ()
				endif
			endif
		endif
		
		if GetWindowClass (GetRealWindow (hwnd)) == wc_TFmMessageDelay &&
			WinClass == wc_TDateTimePicker then
			var string sObjName
			let oCaret = GetFocusObject(iCaret)
			let sObjName = oCaret.AccName(iCaret)
			let iLengthLine = SendMessage (hWnd, wm_GetTextLength, 0, 0)
			;StringLength (sObjName)
			
			if UnitMovement == 2 then
				if GlobalSegmentDate && StringContainsChars (sObjName, cScPeriod)  then
					let GlobalSegmentDate = GlobalSegmentDate -1
					if not GlobalSegmentDate then
						let GlobalSegmentDate = StringSegmentCount (sObjName, cscPeriod)
					endif
				elif GlobalSegmentTime && StringContainsChars (sObjName, cScColon)  then
					let GlobalSegmentTime = GlobalSegmentTime -1
					if not GlobalSegmentTime then
						let GlobalSegmentTime = 1
					endif
				endif
				
			elif UnitMovement== 1 then
				if GlobalSegmentDate && StringContainsChars (sObjName, cScPeriod)  then
					let GlobalSegmentDate = GlobalSegmentDate +1
					if GlobalSegmentDate > StringSegmentCount (sObjName, cscPeriod) then
						let GlobalSegmentDate = 1
					endif
				elif GlobalSegmentTime && StringContainsChars (sObjName, cScColon)  then
					let GlobalSegmentTime = GlobalSegmentTime +1
					if GlobalSegmentTime > StringSegmentCount (sObjName, cscColon) then
						let GlobalSegmentTime = 1
					endif
				endif
			endif
			SayObjectTypeAndText ()
			return
		endif
		
		;SayCharacterUnit(UnitMovement)
		if (WinClass == wc_TAddressBookGrid ) && IsPCCursor () then
			let hHeaderWindow = FindWindow (GetRealWindow (hWnd), wc_THeaderControl, cscNull)
			let ocaret = GetObjectFromEvent (hHeaderWindow, objid_client, childid_self, icaret)
			let iChildCount = ocaret.AccChildCount
			if UnitMovement ==UnitMove_Next && giCurColumn< iChildCount then
				let giCurColumn= giCurColumn+1
			elif UnitMovement == UnitMove_Prior && giCurColumn> 2 then
				let giCurColumn= giCurColumn-1
			endif
			ReadTheDestinationCell (hWnd, giCurTop, giCurBottom, giCurColumn)
			return
		endif
		SayCharacterUnit(UnitMovement)
	endif
EndFunction

Script SayNextWord(optional int bMove)
	var
	int iChild, int iTemp, int iState,
	string sColumnText, object oColumn, object oText, string sTextLine,
	string WinClass,
	handle hWnd
	
	let hWnd=GetFocus()
	let WinClass = GetWindowClass (hwnd)
	if IsJAWSCursor () ||  IsInvisibleCursor () || IsVirtualPCCursor () || UserBufferIsActive () then
	else
		if WinClass ==wc_TMemo then
			if GetCharacter () == cscspace then
				NextCharacter ()
				if GetWord () != cscSpace then
					say(GetWord (), ot_Word)
					return
				else
					SayCharacter ()
					return
				endif
			endif
		endif
		
		if (IsFolderList (hwnd) || IsMessageList (hwnd) || GetWindowClass (hwnd) == wc_TMailDispatcherGrid)
			&& GetWindowClass (GetForegroundWindow ()) != wc_TfrmCustomizer2
			&& IsPCCursor () && !IsVirtualPCCursor ()
			then
			if bMove then
				TypeCurrentScriptKey ()
				return
			endif
			let oColumn = GetObjectFromEvent (hwnd, objid_hscroll, 4, iTemp)
			let oText = GetCurrentObject (iChild)
			GetObjectText (oText, iChild, sColumnText)
			let iState = ocolumn.AccState(iTemp)
			while (iState ==0)
				oColumn.AccDoDefaultAction(iTemp)
				let iState = ocolumn.AccState(iTemp)
				pause()
				if iState ==0
					GetObjectText (oText, iChild, sTextLine)
					let sColumnText = sColumnText + sTextLine
				endif
			endWhile
			say (sColumnText, ot_line)
			let oColumn = GetObjectFromEvent (hwnd, objid_hscroll, 2, iTemp)
			let iState = ocolumn.AccState(iTemp)
			while (iState ==0)
				oColumn.AccDoDefaultAction(iTemp)
				let iState = ocolumn.AccState(iTemp)
				if IsKeyWaiting () then
					return
				endif
			endWhile
			return
		endif
	endif
	SayWordUnit(UnitMove_Next)
EndScript

Script SayPriorWord(optional int bMove)
	var
	object oHeader, object oHScroll,
	int lc,int rc, int tc, int bc, int wc, int hc,
	int maxHeader, int iTemp, int iHScroll, int iChild, int iTopPiksel,
	string sHeader, string sText,
	string WinClass,
	handle hWnd, handle hWindowHeader
	
	let hWnd=GetFocus()
	let WinClass = GetWindowClass (hwnd)
	if IsJAWSCursor () || IsInvisibleCursor () || IsVirtualPCCursor () || UserBufferIsActive () then
		SayWordUnit(UnitMove_Prior)
	else
		if WinClass ==wc_TAddressBookGrid then
			let oHScroll = GetObjectFromEvent (hWnd, objid_hscroll, 2, iHScroll)
			While (oHScroll.accstate(iHScroll) != STATE_SYSTEM_INVISIBLE)
				oHScroll.AccDoDefaultAction(iHScroll)
			EndWhile
			
			let hWindowHeader = FindWindow (GetRealWindow (hWnd), wc_THeaderControl, cscNull)
			let iChild = 2
			let oHeader = GetObjectFromEvent (hWindowHeader, objid_client, iChild, iTemp)
			let maxHeader =oHeader.AccChildCount
			
			while iTemp < maxHeader
				let oHeader = GetObjectFromEvent (hWindowHeader, objid_client, iChild, iTemp)
				oHeader.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
				oHeader.AccLocation(intref(lc), intref(tc), intref(wc), intref(hc), iTemp)
				let lc = lc + 1
				let rc = lc + wc
				let sText = GetTextInRect (lc, giCurTop, rc, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
				let sText = GetTextInRect (lc, giCurTop, rc, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
				
				let oHScroll = GetObjectFromEvent (hWnd, objid_hscroll, 4, iHScroll)
				While (oHScroll.accstate(iHScroll) != STATE_SYSTEM_INVISIBLE) &&
					(oHeader.accstate(itemp) & STATE_SYSTEM_INVISIBLE) &&
					(GetWindowRight (hWindowHeader) < rc)
					oHScroll.AccDoDefaultAction(iHScroll)
					oHeader.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
					oHeader.AccLocation(intref(lc), intref(tc), intref(wc), intref(hc), iTemp)
					let Lc = Lc + 1
					let Rc = Lc + Wc
					let sText = GetTextInRect (lc, giCurTop, rc, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
					if !sText then
						let sText = GetTextInRect (lc, giCurTop, rc, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
					endif
					if GetTextInRect (lc, GetLinetop (), rc, GetLineBottom (), 0, ignorecolor, ignorecolor, 0, 0) then
						let sText = GetTextInRect (lc, giCurTop, rc, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
					endif
				endwhile
				
				if !(oHeader.accstate(itemp) & STATE_SYSTEM_INVISIBLE) && (GetWindowRight (hWindowHeader) < rc) then
					oHScroll.AccDoDefaultAction(iHScroll)
					oHeader.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, iTemp)
					oHeader.AccLocation(intref(lc), intref(tc), intref(wc), intref(hc), iTemp)
					let Lc = Lc + 1
					let Rc = Lc + Wc
					let sText = GetTextInRect (lc, giCurTop, rc, giCurBottom, 0, ignorecolor, ignorecolor, 0, 0)
				endif
				
				let sHeader = oHeader.AccName(iTemp)
				if !sText then
					say (sHeader, OT_line)
					delay(2)
					FindGraphickColorsMarkup (hWindowHeader, lc, giCurTop, rc, giCurBottom)
				endif
				if sText then
					say (sHeader, OT_HELP_BALLOON)
					say (sText, ot_line)
				endif
				
				let iChild = iTemp +1
			endwhile
			
			let oHScroll = GetObjectFromEvent (hWnd, objid_hscroll, 2, iHScroll)
			While (oHScroll.accstate(iHScroll) != STATE_SYSTEM_INVISIBLE) &&
				(oHeader.accstate(giCurColumn) & STATE_SYSTEM_INVISIBLE)
				oHScroll.AccDoDefaultAction(iHScroll)
			EndWhile
			
			return
		endif
		
		if IsFolderList (hwnd) then
			let oHeader = GetCurrentObject (iChild)
			SayTextItem (hWnd, oHeader, iChild)
			return
		elif IsMessageList (hwnd) then
			if bMove then
				TypeCurrentScriptKey ()
				return
			endif
			SayFocusedWindow ()
			return
		endif
		
		if GetWindowClass (hwnd) == wc_TMailDispatcherGrid
			&& GetWindowClass (GetForegroundWindow ()) != wc_TfrmCustomizer2
			&& IsPCCursor () && !IsVirtualPCCursor ()
			then
			Say (GetWindowText (hwnd, true), ot_line)
			return
		endif
		SayWordUnit(UnitMove_Prior)
		if CaretVisible () &&
			((WinClass == wc_TViewerCss)
			|| (WinClass == wc_TRichViewEdit)
			|| (winClass == wc_TMicroEdW))
			;&& GetWindowTypeCode (hwnd) == WT_MULTILINE_EDIT
			then
			if GetCharacter () == cscNull then
				PriorCharacter ()
				delay(2)
				NextCharacter ()
			endif
		endif
	endif
EndScript

Int Function IsFolderList (handle hWnd)
	var
	string sClass
	
	let hWnd =  GetParent (GetParent (hWnd))
	let sClass = GetWindowClass (hWnd)
	if sClass == wc_TFoldersFrame
		&& GetWindowClass (GetCurrentWindow ()) == wc_TXTreeView
		then
		return true
	endif
	return false
EndFunction

Int Function IsMessageList (handle hWND)
	var
	string sClass
	
	let hWnd =  GetParent (GetParent (hWnd))
	let sClass = GetWindowClass (hWnd)
	if sClass == wc_TMessageListFrame
		&& GetWindowClass (GetCurrentWindow ()) == wc_TXTreeView
		then
		return true
	endif
	return false
EndFunction

Script JAWSBackspace()
	var
	string strChar,
	int TheTypeCode,
	string sClass
	If IsVirtualPcCursor () then
		If UserBufferIsActive () then
			Return; Do not process unless so directed in app-specific script file
		EndIf
	EndIf
	let TheTypeCode = GetObjectSubtypeCode(true)
	SaveCursor ()
	PcCursor ()
	If TheTypeCode < 1 then
		let SClass = GetWindowClass (GetFocus ())
	endIf
	If TheTypeCode == WT_TREEVIEW
		|| TheTypeCode == WT_LISTVIEW
		|| TheTypeCode == wt_listBoxItem then
		TypeKey(cksBackspace)
		return
	endIf
	Let strChar = GetPriorCharacter ()
	If strChar == cScNull then
		Let strChar = cMsgBlank1
	ElIf strChar == cScSpace then
		let strChar = cMsgSpace1
	EndIf
	Say (strChar, OT_CHAR)
	TypeKey (cksBackspace)
EndScript

Script JAWSDelete()
	var
	int TheTypeCode,
	int iTemp,
	int childid,
	int bMessageList ,
	object obj,
	handle hWnd,
	handle hAdrWnd,
	handle hWindowViewer,
	string sText,
	string winclass,
	handle hRWnd
	
	let hWnd = GetFocus ()
	let hAdrWnd = hWnd
	let winclass = GetWindowClass (hWnd)
	let hRWnd = FindTopLevelWindow (wc_TMailerForm, "The Bat!")
	if (GetWindowClass (GetRealWindow (hWnd)) != wc_TMsgEditor) then
		
		if (winclass == cwcChromeBrowserClass) then
			if globalPrevFocusForChromeBrowserClass then
				let globalMessageList = globalPrevFocusForChromeBrowserClass
				let globalFocuswindow = globalPrevFocusForChromeBrowserClass
			endif
			
			let hWnd = DefinitionNumberOfClasses (hWnd)
			if !hWnd then
				let hWnd = FindWindow (hRWnd, wc_TMessageListFrame, cscNull)
				delay(1)
				let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
			endif
			SetFocus (hWnd)
			let winclass = GetWindowClass (hWnd)
		endif
		
		TypeCurrentScriptKey ()
		let gbFlagOfKeystroke = true
		RefreshWindow (hWnd)
		delay(2, 1)
		
		if (cwcChromeBrowserClass == GlobalWinClass) then
			if WinClass != cwcChromeBrowserClass then
				let hWnd = FindWindow (hRWnd, cwcChromeBrowserClass, cscNull)
				delay(1)
				if hWnd then
					let WinClass = GetWindowClass (hwnd)
					let GlobalWinClass = WinClass
				endif
			endif
		endif
		
		SaveCursor ()
		Let TheTypeCode = GetWindowSubTypeCode (hwnd)
		If ! TheTypeCode then
			let TheTypeCode = GetObjectSubtypeCode(true)
		EndIf
		
		delay (1)
		if winclass ==wc_TAddressBookGrid then
			SpeechOff ()
			let giCurTop = GetLineTop ()
			let giCurBottom = GetLineBottom ()
			ReadTheDestinationCell (hAdrWnd, giCurTop, giCurBottom)
			SetFocus(hAdrWnd)
			SpeechOn ()
			delay(1)
			SayLine()
			return
		endif
		
		if GlobalMessageSayall == 2 then
			let hWindowViewer = FindTopLevelWindow (wc_TMailerForm, cscNull)
			let hWindowViewer = FindWindow (hWindowViewer, wc_TMsgViewFrame, cscNull)
			let hWindowViewer = FindWindow (hWindowViewer, globalWinClass, cscNull)
			let hWnd = hWindowViewer
			let WinClass = GetWindowClass (hWnd)
			delay(1)
			if IsWindowVisible (hWnd) then
				let hwnd = FindWindow (GetRealWindow (hwnd), wc_TMessageListFrame, cscNull)
				delay(1)
				let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
				SetFocus (hWnd)
				let globalMessageList = Null ()
				return
			else
				let hwnd = FindWindow (GetRealWindow (hwnd), wc_TMessageListFrame, cscNull)
				delay(1)
				let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
				SetFocus (hWnd)
				let WinClass = GetWindowClass (hwnd)
				let globalMessageList = Null ()
			endif
			return
		endif
		
		if !IsMessageList (hwnd) then
			If (GetWindowClass (GetRealWindow (hWnd)) == wc_TMailerForm || GetWindowClass (GetRealWindow (hWnd)) == wc_TMsgListViewer) &&
				((WinClass== wc_TViewerCss)
				|| (WinClass == wc_TMicroEdW)
				|| (WinClass  == cwcChromeBrowserClass ))
				then
				delay(2)
				NewMessage ()
				return
			endif
		else
			let obj = GetCurrentObject (childID)
			let bMessageList = obj.accChildCount
			if !bMessageList  && winclass == wc_TXTreeView && !iKey then
				if HandlingTheScheme ("TheBatMessageEmptyFolder") == 3 then
					NextWord ()
					PriorWord ()
				endif
			endif
			return
		endif
		
		SayCharacter()
		let gbFlagOfKeystroke = 0
	else
		TypeCurrentScriptKey ()
		if WinClass != wc_TXTreeView then
			SayCharacter()
		endif
	endif
	RestoreCursor ()
EndScript

Script ClearFolder ()
	TypeCurrentScriptKey ()
	let gbCleanOutFolder = true
EndScript

Script DeleteMessage ()
	var
	int iTemp,
	int childid,
	int bMessageList ,
	object obj,
	handle hWnd,
	handle hWindowViewer,
	string sText,
	string winclass,
	handle hRWnd
	
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	let hRWnd = FindTopLevelWindow (wc_TMailerForm, "The Bat!")
	
	if (winclass == cwcChromeBrowserClass) then
		if globalPrevFocusForChromeBrowserClass then
			let globalMessageList = globalPrevFocusForChromeBrowserClass
			let globalFocuswindow = globalPrevFocusForChromeBrowserClass
		endif
		
		let hWnd = DefinitionNumberOfClasses (hWnd)
		if !hWnd then
			let hWnd = FindWindow (hRWnd, wc_TMessageListFrame, cscNull)
			delay(1)
			let hWnd = FindWindow (hWnd, wc_TXTreeView, cscNull)
		endif
		SetFocus (hWnd)
		let winclass = GetWindowClass (hWnd)
	endif
	
	TypeCurrentScriptKey ()
	let gbFlagOfKeystroke = true
	RefreshWindow (hWnd)
	delay(2, 1)
	
	if (cwcChromeBrowserClass == GlobalWinClass) then
		;saystring(WinClass)
		if WinClass != cwcChromeBrowserClass then
			let hWnd = FindWindow (hRWnd, cwcChromeBrowserClass, cscNull)
			delay(1)
			;saystring(GetWindowClass (hWnd))
			if hWnd then
				;sayinteger(90)
				let WinClass = GetWindowClass (hwnd)
				let GlobalWinClass = WinClass
			endif
		endif
	endif
	
	if GlobalMessageSayall == 2 then
		let hWindowViewer = FindTopLevelWindow (wc_TMailerForm, cscNull)
		let hWindowViewer = FindWindow (hWindowViewer, wc_TMsgViewFrame, cscNull)
		let hWindowViewer = FindWindow (hWindowViewer, globalWinClass, cscNull)
		let hWnd = hWindowViewer
		let WinClass = GetWindowClass (hWnd)
		delay(1)
		if IsWindowVisible (hWnd) then
			let hwnd = FindWindow (GetRealWindow (hwnd), wc_TMessageListFrame, cscNull)
			delay(1)
			let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
			SetFocus (hWnd)
			let globalMessageList = Null ()
			return
		else
			let hwnd = FindWindow (GetRealWindow (hwnd), wc_TMessageListFrame, cscNull)
			delay(1)
			let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
			SetFocus (hWnd)
			let WinClass = GetWindowClass (hwnd)
			let globalMessageList = Null ()
		endif
		return
	endif
	
	if !IsMessageList (hwnd) then
		If ;IsPCCursor () &&
			(GetWindowClass (GetRealWindow (hWnd)) == wc_TMailerForm || GetWindowClass (GetRealWindow (hWnd)) == wc_TMsgListViewer) &&
			((WinClass== wc_TViewerCss)
			|| (WinClass == wc_TMicroEdW)
			|| (WinClass  == cwcChromeBrowserClass ))
			;&& IsWindowVisible (hWnd)
			then
			NewMessage ()
			return
		endif
	else
		let obj = GetCurrentObject (childID)
		let bMessageList = obj.accChildCount
		/*
		var Int left, Int Top, Int width, Int height, Int right, Int Bottom
		GetObjectRect (left, right, top, bottom, true, 0)
		let stext = GetTextInRect (left, top, right, bottom, 0, ignorecolor, ignorecolor, 0, 0)
		
		if stext == cscNull || stext == cscSpace then
		;delay(1, 1)
		var Int l, Int t, Int r, Int b
		GetWindowRect (hWnd, l, r, t, b)
		let l = l - GetWindowLeft (hWnd)
		let t = b - t
		SendMessage(hWnd,wm_lbuttonDown, 0, MakeLong (l, t))
		SendMessage(hWnd,wm_lbuttonUp, 0, MakeLong (l, t))
		delay(3)
		*/
		if !bMessageList  && winclass == wc_TXTreeView && !iKey then
			if HandlingTheScheme ("TheBatMessageEmptyFolder") == 3 then
				NextWord ()
				PriorWord ()
			endif
		endif
		return
	endif
EndScript

Script StopControl (optional int RightKey)
	var
	handle hwnd,
	string winclass
	
	let hwnd = GetFocus ()
	
	if RightKey then
		;TypeCurrentScriptKey ()
		TypeKey ("RightKey", 1)
		delay(1)
		return
	endif
	if !IsMessageList (hwnd)
		&& !IsFolderList (hwnd)
		&& GetWindowClass (GetRealWindow (hWnd)) != wc_TMsgEditor
		then
		if FindTopLevelWindow (wc_TMsgListViewer, cscNull) then
			if (GetWindowClass (hWnd) == cwcChromeBrowserClass ) then
				JAWSTopOfFile ()
			endif
			let hwnd = FindTopLevelWindow (wc_TMsgListViewer, cscNull)
			delay (1)
			let hwnd = FindWindow (hWnd, wc_TMessageListFrame, cscNull)
			delay (1)
			let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
			if !IsWindowVisible (hWnd)
				SetFocus (FindWindow (FindTopLevelWindow (wc_TMsgListViewer, cscNull), wc_TMicroEdW, cscNull))
				TypeKey (cksEsc, 1)
				delay(1)
			else
				SetFocus (hwnd)
				let globalWinClass = CSCNull
				let globalMessageList = Null ()
				return
			endif
		endif
		;sayinteger(9)
		PCCursor ()
		let hwnd = FindTopLevelWindow (wc_TMailerForm, cscNull)
		delay(1)
		let hwnd = FindWindow (hWnd, wc_TMessageListFrame, cscNull)
		delay (1)
		let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
		SetFocus (hwnd)
		;SayFocusedWindow ()
		let globalWinClass = CSCNull
		let globalMessageList = Null ()
		return
	endif
EndScript

Void Function NewMessage ()
	var
	int iTemp,
	int childid,
	object obj,
	handle hWindow,
	handle hWnd,
	string winclass
	
	let hWnd= GetFocus ()
	let winclass = GetWindowClass (hWnd)
	;saystring(winclass)
	SaveCursor ()
	let obj = getObjectFromEvent(globalMessageList, OBJID_CLIENT, childID, iTemp)
	let gbMessageList = obj.accChildCount
	if !gbMessageList && (WinClass == GetWindowClass (GetRealWindow (hwnd)) || (WinClass == wc_TXTreeView && !gbMessageList)) then
		let hwnd = GetRealWindow (hWnd)
		;delay (1)
		SetFocus (hwnd)
	endif
	if (gbMessageList && not GlobalMessageSayAllKeys) then
		let hwnd = FindWindow (GetRealWindow (hwnd), wc_TMessageListFrame, cscNull)
		;delay (1)
		let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
		UIARefresh (true, 2)
		SetFocus (hwnd)
	elif !(IsFolderList (hwnd)
		|| IsMessageList (hwnd) || GetWindowClass (GetFocus ()) == wc_TListView)
		&& GetWindowClass (GetForegroundWindow ()) != wc_TMsgEditor
		then
		let hWindow = FindWindow (GetRealWindow (hwnd), cwcChromeBrowserClass , cscNull)
		;pause()
		delay(1)
		;sayinteger(hWindow)
		;saystring(GetWindowClass (hWindow))
		if IsWindowVisible (hWindow) then
			SpeechOff ()
			let winclass = GetWindowClass (hWindow)
			let gbNotRepeatRow = true
			SetFocus (hWindow)
			delay(1, 1)
			let globalMessageList = GlobalPrevFocus
			if GetDocumentPercentage () >5 then
				JAWSTopOfFile ()
				MSAARefresh (true, 1)
				delay(0, 1)
			endif
			SpeechOn ()
		else
			let hWindow = DefinitionNumberOfClasses (hWnd)
			;FindWindow (GetRealWindow (hwnd), wc_TMicroEdW, cscNull)
			if IsWindowVisible (hWindow) then
				SetFocus (hWindow)
				let globalMessageList = GlobalPrevFocus
			else
				let hWindow = FindWindow (GetRealWindow (hwnd), wc_TViewerCss, cscNull)
				if IsWindowVisible (hWindow) then
					SetFocus (hWindow)
					let globalMessageList = GlobalPrevFocus
				endif
			endif
		endif
		let hWindow = FindWindow (GetRealWindow (hWnd), wc_TMsgViewFrame, cscNull)
		let hWindow = FindWindow (hWindow, wc_TXTreeView, cscNull)
		if IsWindowVisible (hWindow) then
			if GlobalSayMessageHeaders && (winClass != wc_TMailerForm) then
				pause ()
				SayMessageHeaders (hdr_From)
				pause()
				SayMessageHeaders (hdr_Subject)
			endif
		endif
		let giReadText = true
		ScheduleFunction (sf_ReadText, 1)
	endif
	delay (1)
	let globalMessageList = Null ()
	RestoreCursor ()
EndFunction

Script SayAll ()
	var handle hWndGlobal, handle hFindWnd,
	handle hRealWindow = FindTopLevelWindow (GetWindowClass (GetRealWindow (GlobalPrevFocus)), GetWindowName (GetRealWindow (GlobalPrevFocus)))
	
	if IsMessageList (GlobalPrevFocus) then
		let hFindWnd = FindWindow (hRealWindow, wc_TViewerCss, cscNull)
		if IsWindowVisible (hFindWnd) then
			let hWndGlobal = hFindWnd
		else
			let hFindWnd = DefinitionNumberOfClasses (hRealWindow)
			if (IsWindowVisible (hFindWnd)) then
				let hWndGlobal = hFindWnd
			else
				let hFindWnd = FindWindow (hRealWindow, cwcChromeBrowserClass , cscNull)
				if IsWindowVisible (hFindWnd) then
					let gbNotRepeatRow = true
					let hWndGlobal = hFindWnd
				else
					say (Msg_Wnd_read, ot_line)
					return
				endif
			endif
		endif
		if GlobalMessageSayAllKeys then
			let globalMessageList = Null ()
		else
			let globalPrevFocusForChromeBrowserClass = GlobalPrevFocus
			let globalMessageList = GlobalPrevFocus
		endif
		SetFocus (hWndGlobal)
		delay(2)
		;sayinteger(GetWindowSubtypeCode (hWndGlobal, false))
		if GetObjectSubTypeCode (true, 0) == wt_static && GetWindowSubtypeCode (hWndGlobal, false) == wt_static then
			delay(1, 1)
		endif
		let globalWinClass = GetWindowClass (hWndGlobal)
	else
		let globalMessageList = Null ()
	endif
	let giReadText = true
	
	;ScheduleFunction (sf_ReadText, 1)
	ReadText ()
EndScript

Void Function ReadText ()
	var
	handle hwnd,
	string winclass
	
	let hwnd = GetFocus ()
	let winclass = GetWindowClass (hwnd)
	;saystring(winclass)
	
	if winclass == wc_TMailerForm then
		let hwnd = FindWindow (GetRealWindow (hwnd), wc_TMessageListFrame, cscNull)
		delay(1)
		let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
		SetFocus (hwnd)
		delay (2)
	endif
	let ikey = true
	if !GlobalMenuMode && giReadText && ikey
		then
		let giReadText = false
		if IsMessageList (hWnd) || DialogActive () || IsFolderList (hWnd) then
			if !gbMessageList then
				if HandlingTheScheme ("TheBatMessageEmptyFolder") then
					NextWord ()
					PriorWord ()
				endif
			endif
			let globalWinClass = CSCNull
			let ikey = false
			return
		endif
		
		if winclass == globalwinclass then
			if (GetWindowClass (GetRealWindow (hwnd)) == wc_TMsgListViewer) && (GetCurrentScriptKeyName () == cksEnter) && GlobalMessageSayall == 2 then
				if !GetJCFOptionFromFile (OutputModesJCF, DocumentName) then
					IniWriteString (OutputModesJCF, DocumentName, sFlagsDocumentName, GetActiveConfiguration () + jcfFileType,true)
				endif
			endif
			if WinClass == cwcChromeBrowserClass
				|| WinClass  == wc_TViewerCss
				then
				let ikey = false
				RefreshWindow (GetFocus ())
				if globalMessageList then
					JAWSTopOfFile ()
					pause()
				endif
				SayAll()
				return
			endif
			let gsPrevBufferText = GetClipboardText ()
			if gsPrevBufferText == cscNull || gsPrevBufferText == cscSpace then
				let gsPrevBufferText = cscSpace
			endif
			SpeechOff ()
			SelectToBottom ()
			delay(1, 1)
			SpeechOn ()
			TypeKey (cksControlIns, 1)
		endif
	endif
EndFunction

Void Function ClipboardChangedEvent ()
	var
	int iTemp, int iChild,
	object oTitleBarClose, handle hVirtualView
	if ClipboardTextChanged == CLIPBOARD_APPENDED then
		SayMessage(OT_JAWS_MESSAGE, cmsgAppendedTextToClipboard_L, cmsgAppendedTextToClipboard_S)
	ElIf ClipboardTextChanged == CLIPBOARD_COPIED then
		SayMessage(OT_JAWS_MESSAGE, cmsg52_L, cmsg52_S)
		let gbAppendedToClipboard = FALSE   ;MS070705 clear clipboard flag
	ElIf ClipboardTextChanged == CLIPBOARD_CUT then
		SayMessage(OT_JAWS_MESSAGE, cmsg51_L, cmsg51_S)
		let gbAppendedToClipboard = FALSE   ;MS070705 clear clipboard flag
	endIf
	let ClipBoardTextChanged = false
	if ikey then
		if !gbOffCopyFromBuffer then
			let gsInBufferText = GetClipboardText ()
			CopyToClipboard (gsPrevBufferText)
			let gsPrevBufferText = cscnull
		endif
		
		if StringLength (gsInBufferText) then
			;sayinteger(StringLength (gsInBufferText))
			UserBufferClear ()
			UserBufferAddText (gsInBufferText)
			;sayinteger(UserBufferGetLength ())
			UserBufferActivate ()
			sayall()
		endif
		let hVirtualView = FindTopLevelWindow (wc_VIRTVIEWHELP, cscnull)
		if hVirtualView then
			let oTitleBarClose = GetObjectFromEvent (hVirtualView, OBJID_TITLEBAR, iChild, iTemp)
			let iChild = oTitleBarClose.accchildcount
			let oTitleBarClose = GetObjectFromEvent (hVirtualView, OBJID_TITLEBAR, iChild, iTemp)
			oTitleBarClose.accDoDefaultAction(iTemp)
		endif
	endif
EndFunction

Script ShowAllMessages ()
	Say (msg_show_all_emails, ot_Status)
	TypeCurrentScriptKey ()
EndScript

Script CopySelectedTextToClipboard ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If ((IsVirtualPCCursor () && !UserBufferIsActive ()) || IsPCCursor ()) && WinClass!= wc_TXTreeView
		&& GetSelectedText ()
		then
		TypeKey (cksControlIns, 1)
		Say (cmsg52_S, ot_Status)
	else
		var
		int iRunningFSProducts
		
		let iRunningFSProducts = GetRunningFSProducts()
		if iRunningFSProducts == product_Jaws
			; virtual viewer was not allowing a copy.
			&&  UserBufferIsActive ()then
			Say (cmsg52_S, ot_Status)
			if IsVirtualPcCursor () then
				CopySelectionToClipboard ()
			else
				TypeKey(cksCopy)
			endIf
			return
		EndIf
		updateClipboard(CLIPBOARD_COPIED)
	endif
EndScript

Script PasteFromClipboard()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If IsPCCursor () && WinClass!= wc_TXTreeView then
		TypeKey (cksPaste)
		if GetRunningFSProducts() == product_MAGic then
			SayCurrentScriptKeyLabel()
		else
			SayFormattedMessage (OT_JAWS_MESSAGE, cmsg53_L, cmsg53_S)
		endIf
	Else
		TypeCurrentScriptKey ()
	EndIf
EndScript

Script NoConversations ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If (WinClass== wc_TXTreeView)
		|| ((WinClass == wc_TViewerCss) || (winClass == wc_TMicroEdW))
		then
		Say (msg_Without_Chains, ot_Status)
		TypeCurrentScriptKey ()
	endif
EndScript

Script LinkOrAddAddress ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If WinClass== wc_TAddressBookGrid
		&& GetWindowClass (GetRealWindow (hWnd)) == wc_TAddressSelector
		then
		Say (msg_add, ot_Status)
	ElIf (WinClass== wc_TXTreeView)
		|| ((WinClass == wc_TViewerCss) || (winClass == wc_TMicroEdW))
		then
		Say (msg_By_Reference, ot_Status)
	endif
	TypeCurrentScriptKey ()
EndScript

Script TopicOrAddAddressAll ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If WinClass== wc_TAddressBookGrid
		&& GetWindowClass (GetRealWindow (hWnd)) == wc_TAddressSelector
		then
		Say (msg_Add_all, ot_Status)
	ElIf (WinClass== wc_TXTreeView)
		|| ((WinClass == wc_TViewerCss) || (winClass == wc_TMicroEdW))
		then
		Say (msg_On_this_topic, ot_Status)
	endif
	TypeCurrentScriptKey ()
EndScript

Script FromOrCleanAddress ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If WinClass== wc_TAddressBookGrid
		&& GetWindowClass (GetRealWindow (hWnd)) == wc_TAddressSelector
		then
		Say (msg_Remove, ot_Status)
	ElIf (WinClass== wc_TXTreeView)
		|| ((WinClass == wc_TViewerCss) || (winClass == wc_TMicroEdW))
		then
		Say (msg_On_Field_From, ot_Status)
	endif
	TypeCurrentScriptKey ()
EndScript

Script ToOrCleanOffFieldAddress ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If WinClass== wc_TAddressBookGrid
		&& GetWindowClass (GetRealWindow (hWnd)) == wc_TAddressSelector
		then
		Say (msg_clear_field, ot_Status)
	ElIf (WinClass== wc_TXTreeView)
		|| ((WinClass == wc_TViewerCss) || (winClass == wc_TMicroEdW))
		then
		Say (msg_In_Field_of_Who, ot_Status)
	endif
	TypeCurrentScriptKey ()
EndScript

Script RecognizePlusFive ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If (WinClass== wc_TXTreeView) then
		Say (msg_By_links_and_subject, ot_Status)
	ElIf WinClass== wc_TAddressBookGrid
		&& GetWindowClass (GetRealWindow (hWnd)) == wc_TAddressSelector
		then
		Say (msg_Clear_all_fields, ot_Status)
	Elif ((WinClass == wc_TViewerCss) || (winClass == wc_TMicroEdW)) then
		Say (msg_Autoencode, ot_Status)
		SayLine ()
	endif
	TypeCurrentScriptKey ()
EndScript

Script Date ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If (WinClass== wc_TXTreeView)
		|| ((WinClass == wc_TViewerCss) || (winClass == wc_TMicroEdW))
		then
		Say (msg_By_Date, ot_Status)
	endif
	TypeCurrentScriptKey ()
EndScript

Script Base64 ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If  (WinClass== wc_TViewerCss)
		|| (WinClass == wc_TRichViewEdit)
		|| (WinClass == wc_TMicroEdW)
		then
		TypeCurrentScriptKey ()
	endif
EndScript

Script DeleteString ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If WinClass== wc_TRichViewEdit
		|| WinClass == wc_TMicroEdW
		then
		Say (msg_Line_deleted, ot_Status)
		TypeCurrentScriptKey ()
		Pause ()
		SayLine ()
	endif
EndScript

Script InDecreasingOrder ()
	Say (msg_descending_order, ot_Status)
	TypeCurrentScriptKey ()
EndScript

Script ReceiveAndSendEMailAllTheBoxes ()
	Say (msg_Get_send_mail_all_boxes, ot_Status)
	TypeCurrentScriptKey ()
EndScript

Script SendMail ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetRealWindow (GetFocus ())
	let winclass = GetWindowClass (hWnd)
	If  winclass == wc_TMsgEditor then
		Say (msg_Place_Outbound, ot_Status)
	Elif winclass == wc_TMailerForm then
		Say (msg_Send_mail, ot_Status)
	endif
	TypeCurrentScriptKey ()
EndScript

Script RetrieveEMailAllTheBoxes ()
	;  ( ) Alt+F2
	var
	handle hWnd,
	string winclass
	let hWnd = GetRealWindow (GetFocus ())
	let winclass = GetWindowClass (hWnd)
	If  winclass == wc_TMsgEditor then
		Say (msg_Save_letter_as_draft, ot_Status)
	Elif winclass == wc_TMailerForm then
		Say (msg_Get_Mail_all_boxes, ot_Status)
	endif
	TypeCurrentScriptKey ()
EndScript

Script GetEMail ()
	if GetWindowClass (GetRealWindow (GetCurrentWindow ())) != wc_TMsgEditor then
		HandlingTheScheme ("TheBatReceivingMail")
	else
		HandlingTheScheme ("TheBatSendMail")
	endif
	TypeCurrentScriptKey ()
EndScript

Script FolderUp ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If (WinClass== wc_TXTreeView)
		&& IsFolderList (hWnd)
		&& IsPCCursor ()
		&& !IsVirtualPCCursor ()
		then
		Say (msg_Folder_up, ot_Status)
		TypeCurrentScriptKey ()
	else
		PerformScript SelectPriorParagraph()
	EndIf
EndScript

Script FolderDown ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If (WinClass== wc_TXTreeView)
		&& IsFolderList (hWnd)
		&& IsPCCursor ()
		&& !IsVirtualPCCursor ()
		then
		Say (msg_Folder_Down
		, ot_Status)
		TypeCurrentScriptKey ()
	else
		PerformScript SelectNextParagraph()
	EndIf
EndScript

Script SelectPriorWord()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If (!IsVirtualPCCursor () && IsPCCursor () && WinClass== wc_TXTreeView)
		&& IsFolderList (hWnd)
		then
		Say (msg_Outward_Parent_level, ot_Status)
		TypeCurrentScriptKey ()
	Else
		PerformScript SelectPriorWord()
	endif
EndScript

Script SelectNextWord ()
	var
	handle hWnd,
	string winclass
	let hWnd = GetFocus ()
	let winclass = GetWindowClass (hWnd)
	If (!IsVirtualPCCursor () && IsPCCursor () && WinClass== wc_TXTreeView)
		&& IsFolderList (hWnd)
		then
		Say (msg_Inside_Previous_folder
		, ot_Status)
		TypeCurrentScriptKey ()
	Else
		PerformScript SelectNextWord()
	endif
EndScript

Script SelectNextCharacter()
	Let nSaySelectAfter = TRUE
	SelectingText(TRUE)
	SelectNextCharacter ()
	SelectingText(FALSE)
	Let nSaySelectAfter = FALSE
EndScript

Script SelectPriorCharacter()
	Let nSaySelectAfter = TRUE
	SelectingText(TRUE)
	SelectPriorCharacter ()
	SelectingText(FALSE)
	Let nSaySelectAfter = FALSE
EndScript



Script Undo()
	TypeKey (cksUndo)
	SayFormattedMessage (OT_JAWS_MESSAGE, cmsg50_L)
EndScript

Script SaySelectedText()
	var
	int StartRow, int StartCol, int EndRow, int EndCol, string StartName, string EndName,
	int bSpell,
	string sSelectedText,
	string sMessageLong,
	int bUsingMarkup
	If IsTrueListView(GetFocus())
		&& GetSelectedText() then
		Return lvSaySelectedText ()
	EndIf
	if GetTableSelectionRange( StartRow, StartCol, StartName, EndRow, EndCol, EndName ) then
		let sMessageLong = FormatString( cmsgSelectedCells_L, StartName, EndName )
		sayFormattedMessage( ot_user_requested_information,sMessageLong )
	EndIf
	let bSpell = (IsSameScript() && GetRunningFSProducts() != product_MAGic)
	if IsWindows7()
		&& StringCompare(GetWindowName(GetRealWindow(GetFocus())),cWnStartMenu) == 0 then
		let sSelectedText = GetObjectName(true)
	else
		let sSelectedText = GetSelectedText (!bSpell);include markup in text if not spelling
	EndIf
	if IsPCCursor() && IsBrailleOnlyRegion() then
		SayFormattedMessageWithVoice (VCTX_MESSAGE, ot_help, cmsgBrlOnlyRegion_l, cmsgBrlOnlyRegion_s)
		return
	endIf
	If ! sSelectedText then
		SayMessage (ot_error, cmsgNothingSelected)
		Return
	EndIf
	if bSpell then
		SayFormattedMessage(OT_SPELL,sSelectedText)
		return
	EndIf
	let sMessageLong = FormatString(cmsg39_L,sSelectedText)
	SayMessageWithMarkup(ot_user_requested_information,sMessageLong,sSelectedText)
EndScript

Script SelectAll ()
	var
	string sItem,
	string sCount,
	handle hWnd,
	int iSubtype
	SelectEntireDocument()
	let hWnd = GetFocus ()
	let iSubtype = GetObjectSubTypeCode (true,1)
	if iSubtype == wt_ListView
		|| iSubtype == wt_ListBox
		|| iSubtype == wt_MultiSelect_ListBox
		|| iSubtype == wt_ExtendedSelect_ListBox then
		Pause()
		If nSaySelectAfter then
			Say(GetWindowText(hWnd, true),ot_line)
			Say(cmsg215_L,OT_SELECT)
		Else
			if GetWindowClass (hWnd) == wc_TXTreeView then
				SelectMessage (sItem, sCount)
				SayFormattedMessage (OT_SELECTED_ITEM, Msg_SelectItem_l, Msg_SelectItem_s, sItem, sCount)
				;say (sItem, ot_line)
				return
			endif
			Say(cmsg215_L,OT_SELECT)
			Say(GetWindowText(hWnd, true),ot_line)
		EndIf
		return
	EndIf
	if GetWindowClass (hwnd) == wc_TMicroEdW
		then
		Say(cmsg215_L,OT_SELECT)
		Say(GetSelectedText (false),ot_line)
	endif
EndScript

void function SayTextSelection(string Select, string sText, int bUseOTChar, optional int bContainsSpeechMarkup)
	var
	int OT
	;OT should be Word unless selecting by char so that each unit selected doesn't have its case indicated
	;unless the user has requested the indication for Words
	if bUseOTChar then
		let OT = OT_CHAR
	else
		let OT = OT_WORD
	endIf
	if GetRunningFSProducts() == product_MAGic then
		Say(sText,OT,bContainsSpeechMarkup)
	else
		If nSaySelectAfter then
			Say(sText,OT,bContainsSpeechMarkup)
			SayMessage(OT_SELECT, select)
		Else
			SayMessage(OT_SELECT, select)
			Say(sText,OT,bContainsSpeechMarkup)
		EndIf
	EndIf
EndFunction

Void Function SelectingText(int nMode)
	; handles setting up for and finishing the process of selecting text
	; called by each of the scripts which does text selection
	var
	handle hWnd,
	string sItem,
	string sCount,
	string strHighlightAfterSelect,
	string strUnselected,
	string strNewlySelected,
	int nChanged,
	int nStart,
	int nChars,
	int nLen,
	int nLeft,
	int nTop,
	int nRight,
	int nBottom
	let hWnd = GetCurrentWindow ()
	if UsingEnhancedEditSupport(GetFocus()) then
		if (nMode) then
			let nLastSelectUnitTime=GetTickCount()
		endIf
		return ; handled by internal code which calls TextSelectedEvent
	endIf
	if nMode then
		let g_strHighlightBeforeSelect = GetSelectedText()
		let nSelectingText = nMode
	else
		if GetWindowClass (hWnd)== wc_TXTreeView then
			SpeechOff ()
			SelectMessage (sItem, sCount)
			SpeechOn ()
			SayFormattedMessage (OT_SELECTED_ITEM, Msg_SelectItem_l, Msg_SelectItem_s, sItem, sCount)
			let nSelectingText = 0
			return
		endif
		delay(1)
		ProcessNewText()
		let nSelectingText = 0
		if IsVirtualPCCursor()
			&& IsJavaWindow (GetFocus ()) == FALSE then
			return
		endIf
		let strHighlightAfterSelect = GetSelectedText()
		let	strUnselected = StringDiff(g_strHighlightBeforeSelect,strHighlightAfterSelect)
		if strUnselected then
			; if there's highlighted text prior to the selection command that
			; doesn't exist after the command, this is either because the command
			; deselected the text or the text scrolled off of the screen.
			; We assume that if the text was at the beginning of the old buffer
			; and it isn't in the new buffer, then it scrolled off.
			; This should be true except when selecting text from bottom to top,
			; and deselecting from top to bottom,
			; something that most people probably don't do
			if ! StringsOverlap(g_strHighlightBeforeSelect,strHighlightAfterSelect,nStart,nChars)
				|| nStart<2 then
				let nLen = stringLength(strUnSelected)
				;shif+uparrow
				SayTextSelection(cmsg214_L,strUnSelected,nLen==1)
				let nChanged = nChanged+1
			endIf
		endIf
		let strNewlySelected = StringDiff(strHighlightAfterSelect,g_strHighlightBeforeSelect)
		if strNewlySelected then
			let nLen = stringLength(strNewlySelected)
			;shift+downarrow
			SayTextSelection(cmsg215_L,strNewlySelected,
			nLen==1 || (nLen<=3 && stringContains(strNewlySelected,"\r")))
			let nChanged = nChanged+1
		endIf
		if !nChanged then
			;screen probably scrolled
			let nLen = stringLength(strHighlightAfterSelect)
			if StringsOverlap(g_strHighlightBeforeSelect,strHighlightAfterSelect,nStart,nChars) then
				let strNewlySelected =  stringRight(strHighlightAfterSelect,nLen-nChars)
				let nLen = stringLength(strNewlySelected)
				; Fixes problem where
				; string contained a newline char causing the word blank or a newline to be
				; indicated prior to speaking the newly selected text
				if stringLeft(strNewlySelected,1)==cScBufferNewLine
					&& nLen > 1
					&& substring(strNewlySelected,2,1) !=cScBufferNewLine then
					let strNewlySelected=stringChopLeft(strNewlySelected,1)
					let nLen=nLen-1;
				endIf
				SayTextSelection(cmsg215_L,strNewlySelected, nLen==1)
			else
				; strings didn't overlap, just speak the current line as being selected
				if GetItemRect (GetCursorCol(), GetCursorRow(), nLeft, nRight, nTop, nBottom, it_Line) then
					let strNewlySelected=GetTextInRect (nLeft, nTop, nRight, nBottom, attrib_Highlight, ignoreColor, ignoreColor, FALSE, FALSE)
				else
					let strNewlySelected=getLine()
				endIf
				let nLen = stringLength(strNewlySelected)
				;shift+ end, home, pageup, pagedown.
				SayTextSelection(cmsg215_L,strNewlySelected, nLen==1)
			endIf
		endIf
	endIf
EndFunction

Void Function SelectMessage (string ByRef sSelectItem, string ByRef sItemCount)
	var
	int iChild, int iTemp, int iItemCaunt,
	int i, int e,
	object o,
	handle hwnd
	
	let hWnd = GetCurrentWindow ()
	if GetWindowClass (hWnd) == wc_TXTreeView then
		let o = GetCurrentObject (iChild)
		let iItemCaunt = o.accChildCount
		let e = 1
		let i = 0
		let iChild = o.accnavigate(NAVDIR_FIRSTCHILD, iChild)
		while (e <= iItemCaunt)
			;sayinteger(ichild)
			let iTemp = o.accState(iChild)
			if STATE_SYSTEM_SELECTED & iTemp then
				let i = i + 1
			endif
			let e = e +1
			let iChild = o.accnavigate(NAVDIR_DOWN, iChild)
			if IsKeyWaiting () then
				return
			endif
		endwhile
		let sSelectItem = IntToString (i)
		let sItemCount = IntToString (iItemCaunt)
	endif
	return
EndFunction

Script NextFollowingMessage ()
	var
	handle hWnd
	TypeCurrentScriptKey ()
	let hWnd = GetCurrentWindow()
	if !(IsFolderList (hWnd) || IsMessageList (hWnd)) then
		Say (msg_Following, ot_jaws_message)
		PreviousOrFollowingMessage ()
	endif
EndScript

Script PreviousMessage ()
	var
	handle hWnd
	TypeCurrentScriptKey ()
	let hWnd = GetCurrentWindow()
	if !(IsFolderList (hWnd) || IsMessageList (hWnd)) then
		Say(msg_Previous, ot_jaws_message)
		PreviousOrFollowingMessage ()
	endif
EndScript

Void Function PreviousOrFollowingMessage ()
	NewMessage()
	pause()
	return
EndFunction

Void Function TopEdgeEvent (handle WindowHandle)
	var
	int iWinType
	Let iWinType = GetObjectSubTypeCode (true, 1)
	;sayinteger(iWinType)
	If iWinType == WT_MULTISELECT_LISTBOX ||
		iWinType == WT_EXTENDEDSELECT_LISTBOX ||
		iWinType == WT_LISTBOX||
		iWinType == WT_LISTVIEW ||
		iWinType == WT_LISTBOXITEM||
		iWinType == WT_TREEVIEW then
		if HandlingTheScheme ("TheBatTopEdge") ==3 then
			ProcessBoundaryStrike (WindowHandle, TopEdge)
		endif
		Return
	endIf
EndFunction

Void Function BottomEdgeEvent (handle WinHandle)
	var
	int iWinType
	Let iWinType = GetObjectSubTypeCode (true, 1)
	If iWinType == WT_MULTISELECT_LISTBOX ||
		iWinType == WT_EXTENDEDSELECT_LISTBOX ||
		iWinType == WT_LISTBOX||
		iWinType == WT_LISTVIEW ||
		iWinType == WT_TREEVIEW then
		if HandlingTheScheme ("TheBatBottomEdge") == 3 then
			ProcessBoundaryStrike (WinHandle, BottomEdge)
		endif
		Return
	endIf
EndFunction

Void Function TooltipEvent (handle hWnd, string strText)
	CheckForAimSignIns(hwnd)
	;SayInteger (34)
	if strText== Wn_MainMenu then
		;SetFocus (hwnd)
	endif
	PCCursor ()
	if GetWindowClass (hWnd) != wc_TTBXFloatingWindowParent then
		let strLastTooltip = strText
		;SayFormattedMessage (ot_tool_tip, strLastToolTip)
	endif
	;SayLine ()
EndFunction

Void Function SayHighlightedText (handle hWND, string buffer)
	var
	int iChild, int iTemp,
	object obj,
	handle hWindows,
	string sObjName,
	string winclass
	;sayinteger(90)
	let winclass = GetWindowClass (hwnd)
	;saystring(winclass)
	if WinClass == wc_TAddressBookGrid
		|| WinClass == wc_TMicroEdW
		|| WinClass == wc_TRVColorCombo
		|| WinClass == wc_TViewerCss
		
		then
		return
	endif
	
	if DialogActive () then
		return
	endif
	
	if ((winclass == wc_TXTRichEdit)
		&& (GetWindowClass (GetRealWindow (hwnd)) == wc_TMsgEditor))
		||(GetWindowClass (GetRealWindow (hwnd)) == wc_TMsgRedirector)
		then
		;SayLine ()
		return
	endif
	
	if (winclass == wc_TListView || winclass == wc_TXTreeView
		|| winclass == wc_TEdit
		|| (winclass == wc_TListBox)
		&& (GetWindowClass (GetRealWindow (hWnd)) == wc_TActionEditor)
		|| GetWindowClass (GetRealWindow (hWnd)) == wc_TUserDialog
		
		|| GetWindowClass (GetRealWindow (hWnd)) == wc_TSmartBat)
		then
		return
	endif
	
	if GetWindowClass (GetRealWindow (hWnd)) == wc_TActionEditor then
		return
	endif
	
	SayHighlightedText (hWND, buffer)
EndFunction

void function FocusChangedEventEx (
	handle hwndFocus, int nObject, int nChild,
	handle hwndPrevFocus, int nPrevObject, int nPrevChild,
	int nChangeDepth)
	var
	handle hwndNull,
	handle hFocus,
	string sClass,
	int nType
	;sayinteger(1)
	
	UIAFocusChangedEventEx()
	
	;let hFocus = FindTopLevelWindow (wc_TXTHeaderDropdownList, cscNull)
	;if IsWindowVisible (hFocus) then
	;let hwndFocus = hFocus
	;saystring(GetWindowClass (hFocus))
	;SetFocus (hwndFocus)
	;endif
	PreProcessFocusChangedEventEx(hwndFocus, nObject, nChild, hwndPrevFocus, nPrevObject, nPrevChild, nChangeDepth)
	let sClass = GetWindowClass(hwndFocus)
	let nType = GetObjectSubTypeCode (true)
	if MenuProcessedOnFocusChangedEventEx(hwndFocus,hwndPrevFocus,nType,nChangeDepth) then
		return
	EndIf
	if ProcessTaskSwitchList(hWndFocus) then
		return
	EndIf
	EnsureVistaDesktopTrackingInMagic(hWndFocus,nType)
	ProcessEventOnFocusChangedEventEx(hwndFocus,nObject,nChild,hwndPrevFocus,nPrevObject,nPrevChild,nChangeDepth,sClass,nType)
EndFunction

/*
void function PreProcessFocusChangedEventEx(
handle hwndFocus, int nObject, int nChild,
handle hwndPrevFocus, int nPrevObject, int nPrevChild,
int nChangeDepth)
;; Stop speech if all of the following conditions are true.
;; 1. The "Interrupt Speech When A Dialog Box Is Created" option is enabled.
;; 2. The current real window is different from the previous real window.
;; 3. The current real window is either a dialog box or a Windows Forms window.
var handle realWindow = GetRealWindow(hwndFocus)
if (
gbInterruptSpeechWhenADialogBoxIsCreated
&& realWindow != GlobalPrevReal
&& (DialogActive() || IsWinFormsWindow(realWindow))
)
if (ShouldItemSpeak(OT_DEBUG))
OutputDebugString("Interrupt Speech For Dialog or Windows Forms Creation")
EndIf
StopSpeech()
EndIf
if SayLBDeselectedItemScheduleID != 0
UnscheduleFunction(SayLBDeselectedItemScheduleID)
SayLBDeselectedItemScheduleID = 0
endIf
if giFN_SpeakInvisibleWindow then
unScheduleFunction (giFN_SpeakInvisibleWindow)
endIf
ProcessGestureSelectionModeOnFocusChange(hwndFocus, nObject, nChild, hwndPrevFocus, nPrevObject, nPrevChild, nChangeDepth)
MonitorFormsModeComboBox(hwndFocus,hwndPrevFocus,nChild)
if nChangeDepth > -1 || hwndFocus != hwndPrevFocus then
; destroy cache used to filter extra speaking in winForms drop-down list boxes from combo boxes:
dumpWinformsListItemGlobals ()
endIf
ManageWindows10FocusableProgressBarListener()
EndFunction
*/

void function ProcessEventOnFocusChangedEventEx(
	handle hwndFocus, int nObject, int nChild,
	handle hwndPrevFocus, int nPrevObject, int nPrevChild,
	int nChangeDepth, string sClass, int nType)
	var
	handle hFocus,
	handle hPopup,
	int nParentType
	;sayinteger(2)
	;saystring(sClass)
	pause()
	let hFocus = FindTopLevelWindow (wc_TAddressEditor, cscNull)
	if IsWindowObscured (hFocus) && IsWindowVisible (hFocus) then
		StopSpeech ()
	endif
	
	if stringIsBlank (sClass)
		sClass = getWindowClass (hwndFocus)
	endIf
	if nChangeDepth == -1 then
		return ActiveItemChangedEvent(hwndFocus,nObject,nChild,hwndPrevFocus,nPrevObject,nPrevChild)
	EndIf
	;if nChangeDepth == 0
	if hwndFocus == hwndPrevFocus then
		if sClass == cwc_SysTreeView32 then
			return ActiveItemChangedEvent(hwndFocus,nObject,nChild,hwndPrevFocus,nPrevObject,nPrevChild)
		elif sClass == cwc_Toolbar then
			;Address ToolBar:
			if nType == WT_SPLITBUTTON then
				return ActiveItemChangedEvent(hwndFocus,nObject,nChild,hwndPrevFocus,nPrevObject,nPrevChild)
			EndIf
		elif sClass == cwc_DirectUIhWND then
			let nParentType = GetObjectSubtypeCode(true,1)
			;File and folder list:
			if nType == wt_ReadOnlyEdit
				&& nParentType == wt_ListBoxItem then
				return ActiveItemChangedEvent(hwndFocus,nObject,nChild,hwndPrevFocus,nPrevObject,nPrevChild)
				;Header ListBox SplitButtons:
			elif nType == WT_SPLITBUTTON
				&& nParentType == wt_ListBox then
				return ActiveItemChangedEvent(hwndFocus,nObject,nChild,hwndPrevFocus,nPrevObject,nPrevChild)
			EndIf
		EndIf
	EndIf
	
	;Handle tree views where depth changes but the window does not.
	;Object remains the same as the child id is the only change that affects selection
	;in IE, the object IDs actually change but we still want to speak using active item
	if (nType == WT_TREEVIEW || nType == WT_TREEVIEWITEM)
		if ((sClass== cwcChromeBrowserClass || nObject == nPrevObject)  && hwndFocus == hwndPrevFocus)
			return ActiveItemChangedEvent(hwndFocus,nObject,nChild,hwndPrevFocus,nPrevObject,nPrevChild)
		endIf
	endIf
	
	
	let hPopup = FindTopLevelWindow (wc_TXTHeaderDropdownList, cscNull)
	if GetWindowClass (hPopup) == wc_TXTHeaderDropdownList
		&& IsWindowVisible (hPopup)
		then
		let hwndFocus = hPopup
		return ;ActiveItemChangedEvent(hwndFocus,nObject,nChild,hwndPrevFocus,nPrevObject,nPrevChild)
	else
		if gbNotRepeatRow  && sClass == cwcChromeBrowserClass then
			;sayinteger(gbNotRepeatRow )
			let gbNotRepeatRow  = false
			return
		endif
		return FocusChangedEvent(hwndFocus,hwndPrevFocus)
	endif
EndFunction

Void Function  ActiveItemChangedEvent (handle curHwnd, int curObjectId, int curChildId,
	handle prevHwnd, int prevObjectId, int prevChildId)
	var
	object obj,
	object oListItem,
	string sTextRec,
	string sObjName,
	string sRealClass,
	string sClass,
	int iRole,
	int iChild,
	int iObjtype,
	handle hReal
	
	;sayInteger (3)
	let globalWinClass = cscNull
	let sClass = GetWindowClass (curHwnd)
	let hReal = GetRealWindow (curHwnd)
	let sRealClass = GetWindowClass (hReal)
	let obj = GetCurrentObject (curChildId)
	let sObjName = obj.AccName(curChildId)
	let iObjtype= GetObjectSubTypeCode (true, 1)
	
	if (IsFolderList (curHwnd) || IsMessageList (curHwnd)) then
		SayFocusedWindow ()
		return
	endif
	
	if sRealClass == wc_TGlobalPrefDlg
		|| sRealClass == wc_TFolderSelector
		|| sRealClass == wc_TMessageFinder
		||sRealClass == wc_TExtSetup
		||sRealClass == wc_TAddrHistoryScanner
		||sRealClass == wc_TImapNewFolderManager
		||sRealClass == wc_TfmDwnldUrlMngr
		||sRealClass == wc_TActionEditor
		||sRealClass == wc_TFldFavSetup
		||sRealClass == wc_TVProfileEditor
		||sRealClass == wc_TABMassAdder
		then
		if sClass == wc_TXTreeView then
			let oListItem = GetCurrentObject (iChild)
			GetObjectText (oListItem, iChild, sTextRec)
			Say (sTextRec, ot_line)
			Say (PositionInGroup (), OT_POSITION)
			return
		elif sClass == wc_TTreeView then
			SayObjectActiveItem ()
			return
		else
			SayObjectTypeAndText ()
		endif
		return
	endif
	
	if sRealClass == wc_TWMESpellSuggester && sClass == wc_TListView then
		var
		int l, int t, int w, int h, int r, int b
		let obj = GetCurrentObject (iChild)
		obj.AccLocation(intRef(l), intRef(t), intRef(w), intRef(h), iChild)
		let l = l +1
		let r = l + w
		let t = t +1
		let b = t + h
		let l = (l - GetWindowLeft (curHwnd)) + (r - l)>>1
		let t = (t - GetWindowTop (curHwnd)) + (b - t)>>1
		SendMessage (curHwnd, wm_lButtonDown, 0, MakeLong (l, t))
		SendMessage (curHwnd, wm_lButtonUp, 0, MakeLong (l, t))
		delay(1)
	endif
	if (GetObjectSubTypeCode (true, 0) == WT_LISTBOXITEM || iObjtype == WT_LISTBOX)
		&& (sRealClass == wc_TfrmCustomizer2) then
		let obj = GetCurrentObject (curChildId)
		if obj then
			GetObjectText (obj, curChildId, sTextRec)
			if GetObjectName (true, 0) !=  sTextRec
				&& !StringDiff (sTextRec, GetObjectName (true, 0)) then
				if StringContains (obj.AccName(curchildid), sTextRec) then
					SayObjectActiveItem (false)
					return
				else
					let sTextRec = GetObjectName (true, 0) ;+ sTextRec
				endif
			endif
			Say (sTextRec, ot_line)
		else
			SayObjectActiveItem (false)
		endif
		return
	endif
	
	if sRealClass == wc_TViewModeSetup ||
		sRealClass == wc_TSelectAccs
		|| sRealClass == wc_TBookSelector
		|| sRealClass == wc_TFolderSetConfigurator
		|| sRealClass == wc_TGlbBackup
		|| sRealClass == wc_TFldColumnsSetup
		&& sClass == wc_TXTVCheckListBox then
		SayObjectTypeAndText ()
		return
	endif
	
	if sClass == wc_TXTHeaderDropdownList then
		SetFocus (curHwnd)
		let obj = GetCurrentObject (curChildId)
		let iRole = obj.accrole(curChildId)
		if iRole == ROLE_SYSTEM_LIST then
			obj.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, 1)
		endif
		if curchildid && iRole == ROLE_SYSTEM_LISTITEM then
			obj.accSelect(SELflag_TAKESELECTION|SELflag_TAKEFOCUS, curChildId)
			let sObjName = obj.accName(curChildId)
			say (sObjName, ot_line)
		endif
		return
	endif
	ActiveItemChangedEvent (curHwnd, curObjectId, curChildId, prevHwnd, prevObjectId, prevChildId)
EndFunction

void function ProcessEventOnFocusChangedEvent(handle AppWindow, handle RealWindow, string RealWindowName,
	handle FocusWindow, handle PrevWindow)
	var int ForceSetupStuffForNewPage
	if appWindow != globalPrevApp then
		;sayinteger(4)
		;we've loaded a new app, and in case no local loadNonJCFOptions gets called,
		;but user has set something in QuickSettings and it is a NonJCF Option:
		loadNonJCFOptions ()
		; Update JCF with Global settings, purge out all prior personalized settings that were loaded.
		; This is only relevant when switching between two browser windows of the same application,
		; e.g two pages loaded in Internet Explorer or Firefox, loaded as separated windows.
		if IsMetroApp () then
			;explicitly do no Personalized Settings code,
			; even though the subsequent app window owner conditions can otherwise come true:
			ForceSetupStuffForNewPage = FALSE
		else
			ForceSetupStuffForNewPage = (StringCompare (GetWindowOwner (AppWindow), GetWindowOwner (GlobalPrevApp))
			== 0)
		EndIf
		if ForceSetupStuffForNewPage then
			SetUpStuffForNewPage (TRUE)
		endIf
	endIf
	let GlobalRibbonState = RibbonsActive()
	if FocusChangedEventShouldProcessAncestors(FocusWindow,PrevWindow)
		ProcessSayAppWindowOnFocusChange(AppWindow, FocusWindow)
		ProcessSayRealWindowOnFocusChange(AppWindow, RealWindow, RealWindowName, FocusWindow)
		FocusChangedEventProcessAncestors(FocusWindow, PrevWindow)
		return
	elif IsJavaWindow(FocusWindow) then
		JavaFocusChangedEvent (FocusWindow, PrevWindow)
		return
	elif ExplorerPaneFocusChangedEvent(FocusWindow,PrevWindow) then
		return
	EndIf
	if GlobalRibbonState != GlobalPrevRibbonState then
		SpeakRibbonStatus(true)
	EndIf
	ProcessSayAppWindowOnFocusChange(AppWindow,FocusWindow)
	ProcessSayRealWindowOnFocusChange(AppWindow,RealWindow,RealWindowName,FocusWindow)
	ProcessSayFocusWindowOnFocusChange(RealWindowName,FocusWindow)
EndFunction

void function ProcessSayFocusWindowOnFocusChange(string RealWindowName, handle FocusWindow)
	;sayinteger(6)
	If GetWindowSubTypeCode (FocusWindow) == WT_STARTMENU
		;Windows XP, the Type code is ListView, so:
		|| 	RealWindowName == cWnStartMenu then
		;If in Start Menu, and not in Win NT or 95,
		;Speak Object Name instead of the whole Object Type And Text information:
		If GISuppressStartMenu  then
			SayObjectActiveItem()
		EndIf
		;Solve Japan problem where Exit Documents menus was not reporting accurate state.
		Let GISuppressStartMenu = TRUE
		return
	EndIf
	;Ensure Start Menu flag is off, since we are not in the Start Menu:
	Let GISuppressStartMenu = FALSE
	If SayFocusedHJDialogWindow(FocusWindow) then
		return
	EndIf
	HandleWebDialogFocusTransition()
	HandleEmbeddedWebBrowserWindowFocusTransition(FocusWindow)
	If !HandleCustomWindows(FocusWindow) then
		;if GetWindowClass (FocusWindow) != cwcChromeBrowserClass then
		SayFocusedWindow()
		;endif
	EndIf
EndFunction

Void Function ScreenStabilizedEvent (handle hwndLastScreenWrite)
	var
	handle hPopup, handle RealHWnd, handle HWnd,
	object obj,
	int iRole, int iChild, int iTemp,
	int lw, int tW, int rW, int bw,
	string sObjName, string RealClass, string TheClass
	
	;sayinteger(6)
	let HWnd = GetFocus ()
	let TheClass = GetWindowClass (hWnd)
	let RealHWnd = GetRealWindow (hWnd)
	let RealClass = GetWindowClass (RealHWnd)
	;saystring(TheClass)
	if TheClass == wc_TXTRichEdit then
		let hPopup = GetFirstChild (RealHWnd)
		if IsWindowVisible (hPopup) && GetWindowClass (hPopup) == wc_TXTHeaderDropdownList then
			var int l, int t, int r, int b
			GetWindowRect (hPopup, l, r, t, b)
			InvisibleCursor ()
			MoveToWindow (hPopup)
			SetRestrictionToRect (l, t, r, b)
			SayLine ()
			return
		endif
	endif
	
	if (TheClass == wc_TAddressBookGrid
		&& (RealClass == wc_TAddrWindow) || RealClass == wc_TAddressSelector)
		&& GetWindowClass (FindWindow (RealHWnd, wc_THeaderControl, cscNull)) == wc_THeaderControl
		then
		SetFocus(hWnd)
		var handle hHeader = FindWindow (GetRealWindow (hWnd), wc_THeaderControl, cscNull)
		if GetWindowClass (hHeader) == wc_THeaderControl then
		endif
		return
	endif
	
	if theClass == wc_TChromiumMessageFrame
		
		&& (RealClass == wc_TMailerForm
		|| RealClass == wc_TMsgListViewer)
		then
		let hWnd = FindWindow (hWnd, cwcChromeBrowserClass , cscNull)
		;saystring(GetWindowClass (hWnd))
		;sayinteger(
		GetObjectRect (lW, rW, tW, bW, true, 0)
		SetFocus(hWnd)
		return
	endif
EndFunction

Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScriptKey)
	KeyPressedEvent (nKey, strKeyName, nIsBrailleKey, nIsScriptKey)
	var
	int iLeftPiksel, int iTopPiksel,
	int wl, int wr, int wt, int wb,
	int l, int t, int r, int b,
	int iChild,
	object obj,
	int iObjtype,
	string sObjText,
	string sClass,
	string sRealClass,
	handle hWindow,
	handle hRealWindow,
	handle hWnd,
	handle hPopup
	;sayinteger(nKey)
	
	;let stemp = stemp + nKey + "\n"
	;saystring(strkeyname)
	
	if ikey then
		KeyPressedControl (strKeyName)
		if globalMessageList &&
			((nKey != key_Shift_Delete) && (nKey != key_delete)
			&& (nKey != key_Alt_Control_RightArrow) && (nKey != key_Alt_Control_LeftArrow))
			&& (nKey != key_leftControl)
			then
			let globalMessageList = Null ()
		endif
	endif
	
	let hwnd = GetFocus ()
	let sClass = GetWindowClass (hWnd)
	let iObjtype= GetObjectSubTypeCode (true)
	let obj = GetCurrentObject (iChild)
	
	if strKeyName != "Enter"  || (strKeyName == "Enter" &&sClass != cwc_Button) then
		;saystring(strkeyname)
		let gsKeyName = strKeyName
	endif
	
	if nKey == key_LeftShift_Enter || nKey == key_RightShift_Enter then
		if (GetWindowClass (GetRealWindow (hWnd)) == wc_TWMESpellSuggester) &&
			sClass == wc_TEdit then
			let hWindow = GetNextWindow (FindWindow (GetRealWindow (hWnd), wc_tButton, wn_Button_Skip))
			let iLeftPiksel = (GetWindowRight (hWnd) -GetWindowLeft (hWnd))>>1
			let iTopPiksel = (GetWindowBottom (hWnd) -GetWindowTop (hWnd))>>1
			SendMessage (hWindow, WM_LButtonDown, 0, MakeLong (iLeftPiksel, iTopPiksel))
			SendMessage (hWindow, WM_LButtonUp, 0, MakeLong (iLeftPiksel, iTopPiksel))
			delay(3)
			let hwnd = GetLastWindow (GetFirstChild (FindTopLevelWindow (wc_TWMESpellSuggester, cscNull)))
			if !IsWindowVisible (hWnd) then
				delay(2)
				let hWnd = FindTopLevelWindow (wc_32770, " ")
				delay(2)
				let hwnd = GetFirstChild (hWnd)
			endif
			SetFocus (hwnd)
			return
		endif
	endif
	
	
	if ((GetWindowClass (GetRealWindow (hwnd)) == wc_TMailerForm) && (GetWindowClass (hWnd) == wc_TXTreeView)) &&
		(strKeyName == cksEnter) && GlobalMessageSayall == 2 then
		if GetJCFOptionFromFile (OutputModesJCF, DocumentName) then
			let sFlagsDocumentName = IniReadString (OutputModesJCF, DocumentName, cscNull, GetActiveConfiguration () +jcfFileType)
			IniWriteString (OutputModesJCF, DocumentName, FlagsNullDocumentName, GetActiveConfiguration () +jcfFileType, true)
		endif
	endif
	
	
	if (nKey == key_tab)
		|| (nKey == key_shift_tab)
		|| (nKey == key_ENTER)
		|| (nKey == key_JawsKey_UpArrow)
		|| (nKey == key_UpArrow)
		|| (nKey == key_DownArrow)
		then
		;sayinteger (9)
		let gbNotSayLine = true
	endif
	
	if nKey == key_SPACEBAR || nKey == key_ShiftSPACEBAR then
		if (sClass == wc_TAddressBookGrid)
			delay(1)
			PerformScript SayLine()
			return
		endif
		if iObjtype == WT_LISTBOXITEM
			&& !IsFolderList (hwnd)
			&& !IsMessageList (hwnd)
			&& !DialogActive ()
			;|| sClass == wc_TSpTBXCheckBox
			|| sClass == wc_TSpTBXRadioButton
			;|| sClass == wc_TXTreeView
			then
			let hRealWindow = GetRealWindow (hwnd)
			let sRealClass = GetWindowClass (hRealWindow)
			
			if sRealClass == wc_TFolderSelector then
				let hwnd = FindWindow (hRealWindow, wc_TbatPanel, cscNull)
				let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
				delay(2)
				SetFocus (hwnd)
				return
			endif
			
			GetWindowRect (hwnd, wl, wr, wt, wb)
			GetObjectRect (l, r, t, b, 1, 0)
			if GetWindowClass (GetRealWindow (hWnd)) == wc_TfmDwnldUrlMngr then
				postMessage (hWnd, wm_lbuttonDown, 0, MakeLong (0, b - wt-9))
				postMessage (hWnd, wm_lbuttonUp, 0, MakeLong (0, b - wt-9))
			endif
			
			if GetWindowClass (GetRealWindow (hWnd)) == wc_TActionEditor then
				postMessage (hWnd, wm_lbuttonDown, 0, MakeLong (wr - l -30, b - wt-9))
				postMessage (hWnd, wm_lbuttonUp, 0, MakeLong (wr - l -30, b - wt-9))
			endif
			
			delay (2)
			if obj then
				GetObjectText (obj, iChild, sObjText)
				Say (sObjText, ot_line)
			endif
			return
		endif
		if (sClass == wc_TFilterConditionText
			|| sClass == wc_TBatStaticText) then
			if obj.accName(iChild) then
				Say (obj.accName(iChild), ot_line)
			else
				SayObjectTypeAndText ()
			endif
			return
		EndIf
		;return
	endif
	
	let hPopup = FindTopLevelWindow (wc_TXTHeaderDropdownList, cscNull)
	if hPopup == hWnd then
		if nKey == key_escape  then
			ShiftTabKey ()
		endif
	endif
	
	;KeyPressedEvent (nKey, strKeyName, nIsBrailleKey, nIsScriptKey)
endFunction

Script enter ()
	var
	int winLeft, int wintop, int winright, int winbottom,
	int ichild, int iclient, int lt, int tt, int wt, int ht, int rt, int bt,
	object oclient,
	string WinClass,
	handle hwnd
	
	SayCurrentScriptKeyLabel ()
	let hwnd = GetFocus ()
	let WinClass = GetWindowClass (hwnd)
	if FindTopLevelWindow (wc_TXTHeaderDropdownList, cscnull) == hWnd
		then
		let hWnd = FindTopLevelWindow (wc_TXTHeaderDropdownList, cscnull)
		GetWindowRect (hWnd, winLeft, winright, wintop, winbottom)
		let oclient = GetObjectFromEvent (hwnd, objid_client, ichild, iclient)
		let oclient = GetCurrentObject (iclient)
		oClient.accLocation(Intref(lT), Intref(tT), Intref(wT), Intref(hT), iClient)
		let lT = lT +1
		let rT = lT + wT
		let tt = tt +1
		let lT = (rT -winleft) >>1
		let bt = (tt -wintop ) +ht>>1
		postMessage(hwnd,wm_lbuttonDown, 0, MakeLong (lt, bt))
		postMessage(hwnd,wm_lbuttonUp, 0, MakeLong (lt, bt))
		ShiftTabKey ()
		JAWSEnd ()
		let gbSetClass = true
		return
	endif
	
	if (GetWindowClass (GetRealWindow (hWnd)) == wc_TWMESpellSuggester) &&
		(WinClass == wc_TListView
		|| GetWindowName (hWnd) == StringSegment (wn_Button_List, cscListSeparator, StringSegmentIndex (wn_Button_List, cscListSeparator, GetWindowName (hWnd), true))
		&& WinClass == wc_TButton || WinClass == wc_TEdit)
		then
		let oClient = GetCurrentObject (iChild)
		if WinClass == wc_TEdit then
			EnterKey (1)
		else
			oClient.AccDoDefaultAction(iChild)
		endif
		delay(3)
		let hwnd = GetLastWindow (GetFirstChild (FindTopLevelWindow (wc_TWMESpellSuggester, cscNull)))
		if !IsWindowVisible (hWnd) then
			delay(2)
			let hWnd = FindTopLevelWindow (wc_32770, " ")
			delay(2)
			let hwnd = GetFirstChild (hWnd)
		endif
		SetFocus (hWnd)
		delay(2, 1)
		return
	elif GetWindowClass (GetRealWindow (hWnd)) == wc_32770 &&
		WinClass == cwc_button then
		EnterKey (1)
		return
	endif
	
	if !iKey then
		if winClass == cwcChromeBrowserClass  then
			var object oUIA = CreateObjectEx ("freedomsci.UIA", false, "UIAScriptAPI.x.manifest"),
			Object oFocus = oUIA.GetFocusedElement (),
			object oLink
			let oLink = oFocus.FindFirst (TreeScope_Descendants, oUIA.CreateStringPropertyCondition (UIA_NamePropertyId, GetObjectName (true, 0)))
			SpeechOff ()
			oLink.GetInvokePattern().Invoke()
			SpeechOn ()
			HandlingTheScheme ("TheBatOpenLink")
			return
		endif
		
		if (WinClass == wc_TViewerCss
			|| WinClass  == wc_TMicroEdW)
			&& (GetWindowClass (GetRealWindow (hwnd)) == wc_TMailerForm
			|| GetWindowClass (GetRealWindow (hwnd)) == wc_TMsgListViewer)
			&& (GetWindowClass (GetRealWindow (hwnd)) != wc_TMsgEditor)
			&& !UserBufferIsActive ()
			then
			var string sLinkText = GetLine (),
			object oItem = CreateObject("WScript.Shell"),
			string sReg,
			string ChopStr,
			int LengthStr
			
			If StringContains (sLinkText, "http") || StringContains (sLinkText, "www") Then
				Let sReg = oItem.RegRead ("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice\\ProgId")
				Let sReg=oItem.RegRead("HKEY_CLASSES_ROOT\\" + sReg + "\\Shell\\Open\\Command\\")
				let LengthStr = StringContains (sLinkText, "http") -1
				let ChopStr = stringChopLeft (sLinkText, LengthStr)
				let sLinkText = StringSegment (ChopStr, cscSpace, 1)
				run (FormatString ("%1%2%3 %4", "\"", StringReplaceSubstrings (StringSegment (sReg, "\"", 2), "\\", "\\\\"), "\"", sLinkText))
				HandlingTheScheme ("TheBatOpenLink")
			elIf StringContains (sLinkText, "ftp://") Then
				Let sReg = oItem.RegRead ("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\FTP\\UserChoice\\ProgId")
				Let sReg=oItem.RegRead("HKEY_CLASSES_ROOT\\" + sReg + "\\Shell\\Open\\Command\\")
				let LengthStr = StringContains (sLinkText, "ftp") -1
				let ChopStr = stringChopLeft (sLinkText, LengthStr)
				let sLinkText = StringSegment (ChopStr, cscSpace, 1)
				run (FormatString ("%1%2%3 %4", "\"", StringReplaceSubstrings (StringSegment (sReg, "\"", 2), "\\", "\\\\"), "\"", sLinkText))
				HandlingTheScheme ("TheBatOpenFTP")
			ElIf StringContains (sLinkText, "@") Then
				; Let sReg = oItem.RegRead ("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\mailto\\UserChoice\\ProgId")
				;Let sReg =oItem.RegRead("HKEY_CLASSES_ROOT\\" + sReg + "\\Shell\\Open\\Command\\")
				;if not sReg then
				let sReg = FormatString("%1%2%3", "\"", GetAppFilePath (), "\"")
				;endif
				let LengthStr = StringLength (sLinkText) -StringContains (sLinkText, "@")
				let ChopStr = stringChopRight (sLinkText, LengthStr)
				let LengthStr = StringSegmentCount (ChopStr, cscSpace)
				let sLinkText = StringSegment (sLinkText, cscSpace, LengthStr)
				if !StringContains (sLinkText, ":") then
					let sLinkText = FormatString("MailTo:%1", sLinkText)
				endif
				run (FormatString ("%1%2%3 %4", "\"", StringReplaceSubstrings (StringSegment (sReg, "\"", 2), "\\", "\\\\"), "\"", sLinkText))
				HandlingTheScheme ("TheBatChooseAMailbox")
			EndIf
			return
		endif
	endif
	
	if (WinClass == wc_TComboBox || WinClass == wc_tButton)
		&& GetWindowClass (GetRealWindow (hwnd)) == wc_TUserSelectDlg
		&& (GetWindowClass (GetRealWindow (hwnd)) != wc_TMsgEditor)
		then
		EnterKey (1)
		return
	endif
	if UserBufferIsActive () then
		EnterKey (1)
		return
	endif
	/*
	if WinClass == wc_TSpTBXPopupWindowS then
	let oClient = GetCurrentObject (iChild)
	;saystring(oClient.accname(ichild))
	if oclient.accDefaultAction(iChild) then
	oclient.accDoDefaultAction(iChild)
	delay(3, 1)
	return
	else
	endif
	endif
	*/
	if IsWindowVisible (hWnd) && WinClass == wc_TXTRichEdit then
		SpeechOff ()
		PerformScript RoutePCCursorToJAWS()
		delay(1)
		SpeechOn ()
		SayLine ()
		return
	endif
	TypeCurrentScriptKey ()
EndScript

Void Function SayWord ()
	var String sLinkWord
	if GetCharacterValue (GetCharacter ()) <= 127 then
		If IsPCCursor () && GetWindowClass (GetFocus ()) == wc_TMicroEdW Then
			Let sLinkWord = GetChunk ()
			If StringContains (sLinkWord , "@") && StringContains (sLinkWord , cscPeriod) Then
				Say (cMailLink + sLinkWord, OT_Line)
				return
			elif StringStartsWith (sLinkWord, "http:", 0) || StringStartsWith (sLinkWord, "https:", 0)
				|| StringStartsWith (sLinkWord, "www.", 0) Then
				Say (cURL + sLinkWord, OT_Line)
				Return
			endif
		endif
	endif
	SayWord ()
EndFunction

void function SayWordUnit(int UnitMovement)
	var String sLinkWord
	if UnitMovement == UnitMove_Next then
		NextWord()
		if GetCharacterValue (GetCharacter ()) <= 127 then
			If IsPCCursor () && GetWindowClass (GetFocus ()) == wc_TMicroEdW Then
				Let sLinkWord = GetChunk ()
				If StringContains (sLinkWord , "@") && StringContains (sLinkWord , cscPeriod)
					|| StringStartsWith (sLinkWord, "http:", 0) || StringStartsWith (sLinkWord, "https:", 0)
					|| StringStartsWith (sLinkWord, "www.", 0) Then
					if !StringStartsWith (sLinkWord , GetWord (), 0) then
						while StringContains(sLinkWord, GetWord ())
							NextWord ()
						endWhile
					endif
				endif
			endif
		endif
		
	ElIf UnitMovement == UnitMove_Prior then
		PriorWord()
		if GetCharacterValue (GetCharacter ()) <= 127 then
			If IsPCCursor () && GetWindowClass (GetFocus ()) == wc_TMicroEdW Then
				Let sLinkWord = GetChunk ()
				If StringContains (sLinkWord , "@") && StringContains (sLinkWord , cscPeriod)
					|| StringStartsWith (sLinkWord, "http:", 0) || StringStartsWith (sLinkWord, "https:", 0)
					|| StringStartsWith (sLinkWord, "www.", 0) Then
					while StringContains(sLinkWord, GetWord ()) > 1
						PriorWord()
					endWhile
				endif
			endif
		endif
	else ;no other movement is valid
		return
	EndIf
	if IsLeftButtonDown()
		|| IsRightButtonDown() then
		SelectingText(TRUE)
		pause()
		SelectingText(false)
		return
	endIf
	SayWord()
EndFunction

Void Function KeyPressedControl (string strKeyName)
	var
	int iColumn, int iClient, int iPage,
	object oColumn, object oClient, object oPage,
	int l, int t, int w, int h, int b,
	int lT, int tT, int wT, int hT, int rT, int bt,
	int iCharPage,
	string sPage,
	handle hwnd,
	handle hWindowViewer
	
	if FindTopLevelWindow (wc_TMsgListViewer, cscNull) then
		if strKeyName == cksEscape then
			let hWnd = GetFocus ()
			if !IsMessageList (hwnd)
				&& !IsFolderList (hwnd) then
				let hwnd = FindTopLevelWindow (wc_TMailerForm, cscNull)
				let hwnd = FindWindow (hwnd, wc_TMessageListFrame, cscNull)
				let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
				delay (1)
				TypeKey (cksEscape, 1)
				let globalWinClass = CSCNull
				let globalMessageList = Null ()
				return
			endif
		else
			SpeechOff ()
			let hWindowViewer = FindTopLevelWindow (wc_TMsgListViewer, cscNull)
			if IsWindowVisible (hWindowViewer) then
				SetFocus (hWindowViewer)
				let hWindowViewer = FindWindow (hWindowViewer, globalWinClass, cscNull)
				SetFocus (hWindowViewer)
			endif
		endif
		SpeechOn ()
	endif
	
	let hwnd = GetFocus ()
	if ikey then
		let ikey = false
		
		if GetWindowClass (hWND) == cwcChromeBrowserClass  then
			if ((strKeyName == cksShiftDelete)
				|| (strKeyName == cksDelete)
				|| (strKeyName == cksAltControlRightArrow)
				|| (strKeyName == cksAltControlLeftArrow))
				then
			endif
			return
		endif
		UserBufferClear ()
		UserBufferDeactivate ()
		
		if (strKeyName != cksShiftDelete)
			&& (strKeyName != cksDelete)
			&& (strKeyName != cksAltControlRightArrow) && (strKeyName != cksAltControlLeftArrow)
			then
			
			pause()
			if GetWindowClass (hwnd) == globalwinclass then
				var string sStripAllBlanks = stringStripAllBlanks (gsBufferLine), int iNumChar, int iState, int iAmountOfChar, int i
				let spage = stringStripAllBlanks (GetTextInWindow (hWnd))
				let iNumChar = StringContains (sPage, sStripAllBlanks)
				delay(0, 1)
				let opage = GetObjectFromEvent (hwnd, objid_vscroll, 2, ipage)
				let iState = opage.AccState(iPage)
				;CopyToClipboard (gsBufferLine)
				While not (iState & STATE_SYSTEM_INVISIBLE)
					&& !StringDiff (sPage, sStripAllBlanks)
					&& !iNumChar
					let giCharBuff = giCharBuff - StringLength (sPage)
					opage.AccDoDefaultAction(ipage)
					if giCharBuff < 10000 then
						delay(1)
					endif
					let sPage = stringStripAllBlanks (GetTextInWindow (hWnd))
					let iNumChar = StringContains (sPage, sStripAllBlanks)
					if IsKeyWaiting () then
						return
					endif
				EndWhile
				StopSpeech ()
				PostMessage(hwnd,wm_lbuttonDown, 0, MakeLong (0, 0))
				PostMessage(hwnd,wm_lbuttonUp, 0, MakeLong (0, 0))
				
				GetObjectRect (lt, rt, tt, bt, true, 0)
				let i = StringSegmentCount (GetTextInWindow (hWnd), cscBufferNewLine)
				InvisibleCursor ()
				RouteInvisibleToPc ()
				SetRestrictionToRect (lt, tt, rt, bt)
				if FindString (hwnd, gsBufferLine, S_bottom, S_RESTRICTED) && gsBufferLine then
				else
					let iAmountOfChar = stringlength(stringStripAllBlanks (getline()))
					while i > 0 && iNumChar  >iAmountOfChar
						let i = i - 1
						nextline()
						let iAmountOfChar = iAmountOfChar +stringlength(stringStripAllBlanks (getline()))
						if IsKeyWaiting () then
							return
						endif
					endWhile
				endif
				RoutePcToInvisible ()
				RestoreCursor ()
				PCCursor ()
				delay(2)
			endif
		endif
	endif
	let giCharBuff = false
	;let gsBufferLine = cscNull
	let gsInBufferText = cscnull
EndFunction

Void Function SayAllStoppedEvent ()
	var
	int iCharLine =1,
	int iCharBuff,
	string sLine,
	string sClass,
	string sText,
	handle hWnd,
	handle hWindow
	
	let hWnd = GetCurrentWindow ()
	let sClass = GetWindowClass (hWnd)
	if sClass != cwcChromeBrowserClass  then
		if IsVirtualPCCursor ()
			then
			if ikey then
				JAWSEnd ()
				if GetDocumentPercentage () > 97
					then
					if GlobalMessageSayAllKeys == 2 then
						UserBufferClear ()
						UserBufferDeactivate ()
						{shift+delete}
						NewMessage ()
						return
					else
						let hWindow = FindWindow (FindTopLevelWindow (cscNull, GetWindowName (GetForegroundWindow ())), wc_TMessageListFrame, cscNull)
						let hWindow = FindWindow (hWindow, wc_TXTreeView, cscNull)
						if !IsWindowVisible (hWindow) then
							TypeKey (cksEsc, 1)
							UserBufferClear ()
							UserBufferDeactivate ()
						endif
						SetFocus (hWindow)
					endif
					let iKey = false
					let gsInBufferText = cscnull
					let globalMessageList = Null ()
					return
				else
					JAWSHome ()
					SelectToBottom ()
					StopSpeech ()
					let sText = GetSelectedText ()
					let iCharBuff = StringLength (sText)
					let sLine = StringSegment (sText, cScBufferNewLine, iCharLine)
					let giCharBuff = StringLength (stringStripAllBlanks (sText))
				endif
				
				while StringIsBlank (sLine) || (StringLength (sLine) < 10 && iCharLine < 4)
					&& StringSegmentCount (sText, cscBufferNewLine) > 1
					let iCharLine = iCharLine +1
					let sLine = StringSegment (sText, cScBufferNewLine, iCharLine)
				endwhile
				let gsBufferLine = sLine
				
				if iCharBuff < 250
					&& StringLength (gsInBufferText ) > UserBufferGetLength ()
					then
					let iCharBuff = iCharBuff + StringLength (stringChopLeft (gsInBufferText , UserBufferGetLength ()))
					if (StringLength (gsInBufferText ) - UserBufferGetLength ()) < iCharBuff
						then
						let gbOffCopyFromBuffer = true
						let gsInBufferText = stringChopLeft (gsInBufferText , UserBufferGetLength () - 1)
						UserBufferClear ()
						delay (0, 1)
						ClipboardChangedEvent ()
					endif
				endif
				let gbOffCopyFromBuffer = false
			endif
			return
		endif
	else
		JAWSEnd ()
		if GetDocumentPercentage () > 95 then
			let hwnd = FindTopLevelWindow (wc_TMailerForm, cscNull)
			let hwnd = FindWindow (hWnd, wc_TMessageListFrame, cscNull)
			delay (1)
			let hwnd = FindWindow (hwnd, wc_TXTreeView, cscNull)
			SetFocus (hwnd)
			if GlobalMessageSayAllKeys == 2 then
				TypeKey ("shift+delete", 1)
				delay(1)
				var int iChild, object obj = GetCurrentObject (iChild), int bMesCount = obj.AccChildCount
				if bMesCount then
					HandlingTheScheme ("TheBatDeleteMessage")
				else
					HandlingTheScheme ("TheBatMessageEmptyFolder")
				endif
			endif
			delay(5)
		endif
	endif
EndFunction

Script ScriptFileName()
	var string ScriptVersionAndApp = FormatString(MSG_SelectFunctionToRunItemTemplate, MSG_Script_Reliase_Version, StringSegment (GetAppFileName (), cscPeriod, 1))
	ScriptAndAppNames(ScriptVersionAndApp)
EndScript

Script HotKeyHelp()
	If UserBufferIsActive () then
		UserBufferDeactivate ()
	EndIf
	UserBufferClear ()
	Run(FormatString (msg_RunHelp, GetJAWSSettingsDirectory ()))
EndScript

Void Function EmotAgain ()
	;       .
	PerformScriptByName ("PasteEmot")
EndFunction

Script PasteEmot ()
	Var
	Handle hFocus,
	Int iUsedButton, Int iNumItem, Int iPunct,
	String sAllEmot	, String sItem,
	Int iOpenInput, Int iOk,
	String sNewEmot
	
	SpeechOn ()
	If  !StringContains (GetWindowName (GetRealWindow (GetFocus ())), " ") || GetWindowClass (GetFocus ()) != wc_TMicroEdW Then
		Return
	EndIf
	Let hFocus = GetFocus() ; save the current focus
	Let sAllEmot = IniReadSectionKeys (cSecEmot, cFileEmot)
	;     .  .
	Let iNumItem = DlgSelectItemInList (sAllEmot, "   ", 0, 1, cEmotButton, iUsedButton)
	If iNumItem == 0 || iUsedButton == dlgSelectItemInList_ID_Cancel Then
		SetFocus (hFocus)
		Return
		;   .
	ElIf iUsedButton == dlgSelectItemInList_ID_OK Then
		SetFocus (hFocus)
		Let sItem =cscSpace + IniReadString (cSecEmot, StringSegment (sAllEmot, cscListSeparator, iNumItem), cscNull, cFileEmot) + cscSpace
		Delay (1)
		TypeString (sItem)
		Let iPunct = GetJCFOption (opt_punctuation)
		SetJCFOption (opt_punctuation, 3)
		Say (sItem, OT_Line)
		SetJCFOption (opt_punctuation, iPunct)
		; ,   .
		;   ,  ,   .
	ElIf iUsedButton == dlgSelectItemInList_ID_Custom1 || iUsedButton == dlgSelectItemInList_ID_Custom2 Then
		Let iOpenInput = 1
		While iOpenInput == 1
			Let iOk = InputBox("    =,    ", "/ ", sNewEmot)
			Delay(1)
			If !iOk
				|| sNewEmot == cscNull Then
				SetFocus (hFocus)
				Return
			EndIf
			If StringContains (cscListSeparator + sAllEmot + cscListSeparator, cscListSeparator + StringSegment (sNewEmot, cscEqual, 1) + cscListSeparator) == 0
				|| iUsedButton == dlgSelectItemInList_ID_Custom2 Then
				Let iOpenInput = 0
			Else
				Say ("  ,  ", OT_Line)
			EndIf
		EndWhile
		If iUsedButton == dlgSelectItemInList_ID_Custom1
			&& !StringContains (sNewEmot, cscEqual) Then
			Say (",         ", OT_Line)
			Return
		EndIf
		If iUsedButton == dlgSelectItemInList_ID_Custom1 Then
			Let sItem = StringSegment (sNewEmot, cscEqual, 1)
			Let sNewEmot = StringReplaceSubstrings (sNewEmot, sItem + cscEqual, cscNull)
		Else
			Let sItem = StringSegment (sAllEmot, cscListSeparator, iNumItem)
		EndIf
		If IniWriteString (cSecEmot, sItem, sNewEmot, cFileEmot, 1) Then
			Delay (1)
			Say (" ", OT_Line)
			Delay (5)
			SpeechOff ()
			;      .
			ScheduleFunction ("EmotAgain", 5)
		Else
			Say ("  ", OT_Line)
		EndIf
	ElIf iUsedButton == dlgSelectItemInList_ID_Custom3 Then
		If IniRemoveKey (cSecEmot, StringSegment (sAllEmot, cscListSeparator, iNumItem), cFileEmot, 1)Then
			Say (" ", OT_Line)
			Delay (5)
			;      .
			SpeechOff ()
			ScheduleFunction ("EmotAgain", 5)
		Else
			Say (" ", OT_Line)
		EndIf
	EndIf
	SpeechOn ()
EndScript
